/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.inspectors;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraft.block.Block;

public class NodeInflator
implements INodeInspector {
    private float radius;
    private BlockPos last;
    Species species;
    SimpleVoxmap leafMap;

    public NodeInflator(Species species, SimpleVoxmap leafMap) {
        this.species = species;
        this.leafMap = leafMap;
        this.last = BlockPos.ORIGIN;
    }

    @Override
    public boolean run(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        BlockBranch branch = TreeHelper.getBranch(block);
        if (branch != null) {
            this.radius = 1.0f;
        }
        return false;
    }

    @Override
    public boolean returnRun(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        BlockBranch branch = TreeHelper.getBranch(block);
        if (branch != null) {
            float areaAccum = this.radius * this.radius;
            boolean isTwig = true;
            for (EnumFacing dir : EnumFacing.VALUES) {
                if (dir.equals((Object)fromDir)) continue;
                BlockPos dPos = pos.offset(dir);
                if (dPos.equals(this.last)) {
                    isTwig = false;
                    continue;
                }
                ITreePart treepart = TreeHelper.getTreePart(world, dPos);
                if (!branch.isSameWood(treepart)) continue;
                int branchRadius = treepart.getRadius(world, dPos);
                areaAccum += (float)(branchRadius * branchRadius);
            }
            if (isTwig) {
                this.leafMap.setVoxel(pos, (byte)16);
                SimpleVoxmap leafCluster = branch.getTree().getLeafCluster();
                this.leafMap.BlitMax(pos, leafCluster);
            } else {
                this.radius = (float)Math.sqrt(areaAccum) + this.species.getTapering() * this.species.getWorldGenTaperingFactor();
                float secondaryThickness = this.species.getSecondaryThickness();
                if (this.radius < secondaryThickness) {
                    this.radius = secondaryThickness;
                }
                branch.setRadius(world, pos, (int)Math.floor(this.radius));
                this.leafMap.setVoxel(pos, (byte)32);
            }
            this.last = pos;
        }
        return false;
    }
}

