/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.inspectors;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import net.minecraft.block.Block;

public class NodeTransform
implements INodeInspector {
    DynamicTree fromTree;
    DynamicTree toTree;

    public NodeTransform(DynamicTree fromTree, DynamicTree toTree) {
        this.fromTree = fromTree;
        this.toTree = toTree;
    }

    @Override
    public boolean run(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        int radius;
        BlockBranch branch = TreeHelper.getBranch(block);
        if (branch != null && this.fromTree == branch.getTree() && (radius = branch.getRadius(world, pos)) > 0) {
            world.setBlockState(pos, this.toTree.getDynamicBranch().getDefaultState().withMeta(radius - 1));
            if (radius == 1) {
                this.transformSurroundingLeaves(world, pos);
            }
        }
        return true;
    }

    @Override
    public boolean returnRun(World world, Block block, BlockPos pos, EnumFacing fromDir) {
        return false;
    }

    public void transformSurroundingLeaves(World world, BlockPos twigPos) {
        if (!world.isRemote) {
            for (BlockPos leavesPos : BlockPos.getAllInBox(twigPos.add(-3, -3, -3), twigPos.add(3, 3, 3))) {
                if (this.fromTree.getLeafClusterPoint(twigPos, leavesPos) == 0 || !this.fromTree.isCompatibleGenericLeaves(world, leavesPos)) continue;
                int hydro = 2;
                IBlockState state = world.getBlockState(leavesPos);
                if (state.getBlock() instanceof BlockDynamicLeaves) {
                    BlockDynamicLeaves growingLeaves = (BlockDynamicLeaves)state.getBlock();
                    hydro = growingLeaves.getHydrationLevel(state);
                }
                world.setBlockState(leavesPos, this.toTree.getDynamicLeavesState(hydro));
            }
        }
    }
}

