/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.items;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.BlockState;
import com.ferreusveritas.dynamictrees.api.backport.EnumActionResult;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.EnumHand;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.ItemBackport;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSapling;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class Seed
extends ItemBackport {
    private Species species;

    public Seed(String name) {
        this.func_77637_a(DynamicTrees.dynamicTreesTab);
        this.setUnlocalizedNameReg(name);
        this.setRegistryName(name);
        this.func_111206_d("dynamictrees:" + name);
    }

    public void setSpecies(Species species, ItemStack seedStack) {
        this.species = species;
    }

    public Species getSpecies(ItemStack seedStack) {
        return this.species;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        World world = CompatHelper.getEntityWorld((Entity)entityItem);
        if (entityItem.field_70173_aa >= ModConfigs.seedTimeToLive) {
            BlockPos pos;
            if (!world.isRemote && world.canBlockSeeSky(pos = new BlockPos((Entity)entityItem))) {
                Random rand = new Random();
                ItemStack seedStack = CompatHelper.getEntityItem(entityItem);
                int count = CompatHelper.getStackCount(seedStack);
                while (!(count-- <= 0 || this.getSpecies(seedStack).biomeSuitability(world, pos) * ModConfigs.seedPlantRate > rand.nextFloat() && this.plantSapling(world, pos, seedStack))) {
                }
                CompatHelper.setStackCount(CompatHelper.getEntityItem(entityItem), 0);
            }
            entityItem.func_70106_y();
        }
        return false;
    }

    @Override
    public EnumActionResult onItemUse(ItemStack heldItem, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Species species;
        BlockBonsaiPot bonzaiPot;
        IBlockState blockState = world.getBlockState(pos);
        if (blockState.equals(new BlockState(Blocks.field_150457_bL, 0)) && (bonzaiPot = (species = this.getSpecies(heldItem)).getTree().getBonzaiPot()).setSpecies(world, species, pos)) {
            CompatHelper.shrinkStack(heldItem, 1);
            return EnumActionResult.SUCCESS;
        }
        if (facing == EnumFacing.UP && player.func_82247_a(pos.getX(), pos.getY(), pos.getZ(), facing.getIndex(), heldItem) && player.func_82247_a(pos.getX(), pos.getY() + 1, pos.getZ(), facing.getIndex(), heldItem) && this.plantSapling(world, pos.up(), heldItem)) {
            CompatHelper.shrinkStack(heldItem, 1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean plantSapling(World world, BlockPos pos, ItemStack seedStack) {
        Species species = this.getSpecies(seedStack);
        if (world.getBlockState(pos).getBlock().isReplaceable((IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ()) && BlockDynamicSapling.canSaplingStay(world, species, pos)) {
            return species.placeSaplingBlock(world, pos);
        }
        return false;
    }
}

