/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.renderers;

import com.ferreusveritas.dynamictrees.api.backport.BlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.renderers.RendererHelper;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RendererBranch
implements ISimpleBlockRenderingHandler {
    public static int id;
    public static int renderFaceFlags;
    public static int renderRingSides;
    public static final int faceDown = 1;
    public static final int faceUp = 2;
    public static final int faceNorth = 4;
    public static final int faceSouth = 8;
    public static final int faceWest = 16;
    public static final int faceEast = 32;
    public static final int faceAll = 63;

    public RendererBranch() {
        id = RenderingRegistry.getNextAvailableRenderId();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        BlockBranch branch = (BlockBranch)block;
        float rad = 0.1875f;
        GL11.glTranslatef((float)(-0.5f - rad), (float)-0.5f, (float)-0.5f);
        renderRingSides = 3;
        renderer.func_147782_a(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
        RendererHelper.renderStandardInventoryBlock(block, metadata, modelId, renderer);
        renderRingSides = 48;
        renderer.func_147782_a(0.75, 0.4375, 0.4375, 1.0, 0.5625, 0.5625);
        RendererHelper.renderStandardInventoryBlock(block, metadata, modelId, renderer);
        renderRingSides = 12;
        renderer.func_147782_a(0.375, 0.375, 0.75, 0.625, 0.625, 1.0);
        RendererHelper.renderStandardInventoryBlock(block, metadata, modelId, renderer);
        GL11.glTranslatef((float)(0.5f + rad), (float)0.0f, (float)0.0f);
        int color = branch.getTree().getDynamicLeaves().func_149741_i(branch.getTree().getDynamicLeavesSub() << 2);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        renderer.func_147782_a(0.5 - (double)rad, 0.5 - (double)rad, 0.5 - (double)rad, 0.5 + (double)rad, 0.5 + (double)rad, 0.5 + (double)rad);
        IBlockState primLeaves = branch.getTree().getPrimitiveLeaves();
        RendererHelper.renderStandardInventoryBlock(primLeaves.getBlock(), primLeaves.getMeta(), modelId, renderer);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)(-0.5f - rad), (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        BlockAccess access = new BlockAccess(world);
        if (block instanceof BlockBranch) {
            renderFaceFlags = 63;
            renderRingSides = 0;
            int faceOverrides = 0;
            BlockPos pos = new BlockPos(x, y, z);
            BlockBranch branch = (BlockBranch)block;
            int radius = branch.getRadius(access, pos);
            int[] radii = new int[6];
            int largestConnection = 0;
            int numConnections = 0;
            int sourceDir = 0;
            for (EnumFacing dir : EnumFacing.VALUES) {
                int connRadius = branch.getSideConnectionRadius(access, pos, radius, dir);
                if (connRadius <= 0) continue;
                ++numConnections;
                connRadius = connRadius > radius ? radius : connRadius;
                int dnum = dir.ordinal();
                if (connRadius > largestConnection) {
                    largestConnection = connRadius;
                    sourceDir = dnum;
                }
                radii[dnum] = connRadius;
            }
            if (largestConnection < radius) {
                sourceDir = -1;
            }
            if (sourceDir == -1) {
                sourceDir = 0;
                radii[0] = radius;
                renderRingSides = 1;
                faceOverrides = 1;
            }
            if (radius == 8) {
                if (numConnections == 1) {
                    renderRingSides = 1 << EnumFacing.getFront(sourceDir).getOpposite().ordinal();
                }
                renderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                renderer.func_147784_q(block, x, y, z);
                return true;
            }
            if (numConnections == 0) {
                float min = 0.5f - (float)radius / 16.0f;
                float max = 0.5f + (float)radius / 16.0f;
                renderer.func_147782_a((double)min, 0.0, (double)min, (double)max, 1.0, (double)max);
                renderer.func_147784_q(block, x, y, z);
                return true;
            }
            renderFaceFlags = 0x3C | faceOverrides;
            if (radii[0] == radii[1] && radii[0] != 0) {
                float min = 0.5f - (float)radii[0] / 16.0f;
                float max = 0.5f + (float)radii[0] / 16.0f;
                renderer.func_147782_a((double)min, 0.0, (double)min, (double)max, 1.0, (double)max);
                renderer.func_147784_q(block, x, y, z);
            } else {
                if (radii[0] > 0) {
                    float min = 0.5f - (float)radii[0] / 16.0f;
                    float max = 0.5f + (float)radii[0] / 16.0f;
                    renderFaceFlags |= sourceDir == 0 ? 2 : 0;
                    renderRingSides |= numConnections == 1 && sourceDir == 0 ? 2 : 0;
                    renderer.func_147782_a((double)min, 0.0, (double)min, (double)max, sourceDir == 0 ? (double)max : (double)min, (double)max);
                    renderer.func_147784_q(block, x, y, z);
                }
                if (radii[1] > 0) {
                    float min = 0.5f - (float)radii[1] / 16.0f;
                    float max = 0.5f + (float)radii[1] / 16.0f;
                    renderFaceFlags |= sourceDir == 1 ? 1 : 0;
                    renderRingSides = numConnections == 1 && sourceDir == 1 ? 1 : 0;
                    renderer.func_147782_a((double)min, sourceDir == 1 ? (double)min : (double)max, (double)min, (double)max, 1.0, (double)max);
                    renderer.func_147784_q(block, x, y, z);
                }
            }
            renderFaceFlags = 0x33 | faceOverrides;
            renderer.field_147871_s = 1;
            renderer.field_147869_t = 1;
            if (radii[2] == radii[3] && radii[2] > 1) {
                float min = 0.5f - (float)radii[2] / 16.0f;
                float max = 0.5f + (float)radii[2] / 16.0f;
                renderer.func_147782_a((double)min, (double)min, 0.0, (double)max, (double)max, 1.0);
                renderer.func_147784_q(block, x, y, z);
            } else {
                if (radii[2] > 0) {
                    float min = 0.5f - (float)radii[2] / 16.0f;
                    float max = 0.5f + (float)radii[2] / 16.0f;
                    renderFaceFlags |= sourceDir == 2 ? 8 : 0;
                    renderRingSides = numConnections == 1 && sourceDir == 2 ? 8 : 0;
                    renderer.func_147782_a((double)min, (double)min, 0.0, (double)max, (double)max, sourceDir == 2 ? (double)max : (double)min);
                    renderer.func_147784_q(block, x, y, z);
                }
                if (radii[3] > 0) {
                    float min = 0.5f - (float)radii[3] / 16.0f;
                    float max = 0.5f + (float)radii[3] / 16.0f;
                    renderFaceFlags |= sourceDir == 3 ? 4 : 0;
                    renderRingSides = numConnections == 1 && sourceDir == 3 ? 4 : 0;
                    renderer.func_147782_a((double)min, (double)min, sourceDir == 3 ? (double)min : (double)max, (double)max, (double)max, 1.0);
                    renderer.func_147784_q(block, x, y, z);
                }
            }
            renderer.field_147871_s = 0;
            renderer.field_147869_t = 0;
            renderFaceFlags = 0xF | faceOverrides;
            renderer.field_147875_q = 1;
            renderer.field_147873_r = 1;
            renderer.field_147867_u = 1;
            renderer.field_147865_v = 1;
            if (radii[4] == radii[5] && radii[4] > 1) {
                float min = 0.5f - (float)radii[4] / 16.0f;
                float max = 0.5f + (float)radii[4] / 16.0f;
                renderer.func_147782_a(0.0, (double)min, (double)min, 1.0, (double)max, (double)max);
                renderer.func_147784_q(block, x, y, z);
            } else {
                if (radii[4] > 0) {
                    float min = 0.5f - (float)radii[4] / 16.0f;
                    float max = 0.5f + (float)radii[4] / 16.0f;
                    renderFaceFlags |= sourceDir == 4 ? 32 : 0;
                    renderRingSides = numConnections == 1 && sourceDir == 4 ? 32 : 0;
                    renderer.func_147782_a(0.0, (double)min, (double)min, sourceDir == 4 ? (double)max : (double)min, (double)max, (double)max);
                    renderer.func_147784_q(block, x, y, z);
                }
                if (radii[5] > 0) {
                    float min = 0.5f - (float)radii[5] / 16.0f;
                    float max = 0.5f + (float)radii[5] / 16.0f;
                    renderFaceFlags |= sourceDir == 5 ? 16 : 0;
                    renderRingSides = numConnections == 1 && sourceDir == 5 ? 16 : 0;
                    renderer.func_147782_a(sourceDir == 5 ? (double)min : (double)max, (double)min, (double)min, 1.0, (double)max, (double)max);
                    renderer.func_147784_q(block, x, y, z);
                }
            }
            renderer.field_147875_q = 0;
            renderer.field_147873_r = 0;
            renderer.field_147867_u = 0;
            renderer.field_147865_v = 0;
            return true;
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return id;
    }
}

