/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.seasons;

import com.ferreusveritas.dynamictrees.seasons.ISeasonProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class SeasonProviderBasic
implements ISeasonProvider {
    protected int currentDay = 0;
    protected int day;
    protected int month;
    protected long year;
    protected float season;
    public static final String[] monthNames = new String[]{"Monostus", "Diastus", "Triastus", "Tetrastus", "Pentastus", "Hexastus", "Heptastus", "Octastus"};
    public static final String[] numeralSuffix = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
    public static final String[] seasonNames = new String[]{"Spring", "Summer", "Fall", "Winter"};
    int monthsPerYear = 8;
    int daysPerMonth = 8;
    final int ticksPerDay = 24000;

    public SeasonProviderBasic() {
    }

    public SeasonProviderBasic(int monthsPerYear, int daysPerMonth) {
        this.monthsPerYear = monthsPerYear;
        this.daysPerMonth = daysPerMonth;
    }

    @Override
    public void updateTick(World world, long worldTicks) {
        this.year = worldTicks / (long)(24000 * this.daysPerMonth * this.monthsPerYear);
        this.month = (int)(worldTicks / (long)(24000 * this.daysPerMonth) % (long)this.monthsPerYear);
        this.day = (int)(worldTicks / 24000L % (long)this.daysPerMonth);
        this.season = (float)(this.month * this.daysPerMonth + this.day) / ((float)(this.daysPerMonth * this.monthsPerYear) / 4.0f);
        if (this.currentDay != this.day) {
            this.notifyPlayersOfDate(world);
            this.currentDay = this.day;
        }
    }

    public void notifyPlayersOfDate(World world) {
        String dayString = String.valueOf(this.day + 1) + numeralSuffix[(this.day + 1) % 10];
        String dataString = dayString + " of " + monthNames[this.month] + " " + String.valueOf(this.year) + " S:" + seasonNames[(int)Math.floor(this.season)] + " [" + String.format("%1.2f", Float.valueOf(this.season)) + "] M:" + world.func_72853_d() + " V:" + world.func_72820_D();
        if (!world.field_72995_K) {
            for (Object obj : world.field_73010_i) {
                if (!(obj instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)obj;
                player.func_145747_a((IChatComponent)new ChatComponentText("Date: " + dataString));
            }
        }
    }

    @Override
    public float getSeasonValue() {
        return this.season;
    }

    public int getDayOfMonth() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public long getYear() {
        return this.year;
    }
}

