/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.tileentity;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.blocks.BlockDendroCoil;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityDendroCoil
extends TileEntity
implements IPeripheral {
    private ArrayList<CachedCommand> cachedCommands = new ArrayList(1);
    private String treeName;
    private int soilLife;
    public static final int numMethods = ComputerMethod.countMethods();
    public static final String[] methodNames = new String[numMethods];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheCommand(int method, Object[] args) {
        ArrayList<CachedCommand> arrayList = this.cachedCommands;
        synchronized (arrayList) {
            this.cachedCommands.add(new CachedCommand(method, args));
        }
    }

    public BlockPos getPos() {
        return new BlockPos(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_145845_h() {
        BlockDendroCoil dendroCoil = (BlockDendroCoil)this.func_145838_q();
        World world = new World(this.field_145850_b);
        Object object = this;
        synchronized (object) {
            this.treeName = new String(dendroCoil.getSpecies(world, this.getPos()));
            this.soilLife = dendroCoil.getSoilLife(world, this.getPos());
        }
        object = this.cachedCommands;
        synchronized (object) {
            if (this.cachedCommands.size() > 0 && dendroCoil != null) {
                for (CachedCommand command : this.cachedCommands) {
                    switch (command.method) {
                        case growPulse: {
                            dendroCoil.growPulse(world, this.getPos());
                            break;
                        }
                        case killTree: {
                            dendroCoil.killTree(world, this.getPos());
                            break;
                        }
                        case plantTree: {
                            dendroCoil.plantTree(world, this.getPos(), (String)command.arguments[0]);
                            break;
                        }
                        case setCode: {
                            dendroCoil.setCode(world, this.getPos(), (String)command.arguments[0], (String)command.arguments[1]);
                            break;
                        }
                        case setSoilLife: {
                            dendroCoil.setSoilLife(world, this.getPos(), ((Double)command.arguments[0]).intValue());
                            break;
                        }
                        case createStaff: {
                            dendroCoil.createStaff(world, this.getPos(), (String)command.arguments[0], (String)command.arguments[1], (String)command.arguments[2], (Boolean)command.arguments[3]);
                            break;
                        }
                        case testPoisson: {
                            dendroCoil.testPoisson(world, this.getPos(), ((Double)command.arguments[0]).intValue(), ((Double)command.arguments[1]).intValue(), (Double)command.arguments[2]);
                            break;
                        }
                        case testPoisson2: {
                            dendroCoil.testPoisson2(world, this.getPos(), ((Double)command.arguments[0]).intValue(), ((Double)command.arguments[1]).intValue(), (Double)command.arguments[2], ((Double)command.arguments[3]).intValue());
                            break;
                        }
                    }
                }
                this.cachedCommands.clear();
            }
        }
    }

    public String getType() {
        return "dendrocoil";
    }

    public String[] getMethodNames() {
        return methodNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException {
        if (method < 0 || method >= numMethods) {
            throw new IllegalArgumentException("Invalid method number");
        }
        BlockDendroCoil dendroCoil = (BlockDendroCoil)this.func_145838_q();
        World world = new World(this.field_145850_b);
        if (!world.isRemote && dendroCoil != null) {
            switch (ComputerMethod.values()[method]) {
                case getCode: {
                    return new Object[]{dendroCoil.getCode(world, this.getPos())};
                }
                case getSoilLife: {
                    TileEntityDendroCoil tileEntityDendroCoil = this;
                    synchronized (tileEntityDendroCoil) {
                        return new Object[]{this.soilLife};
                    }
                }
                case getTree: {
                    TileEntityDendroCoil tileEntityDendroCoil = this;
                    synchronized (tileEntityDendroCoil) {
                        return new Object[]{this.treeName};
                    }
                }
                case plantTree: {
                    if (arguments.length >= 1 && arguments[0] instanceof String) {
                        this.cacheCommand(method, arguments);
                        break;
                    }
                    throw new LuaException("Expected: " + methodNames[method] + " treeName<String>");
                }
                case setSoilLife: {
                    if (arguments.length >= 1 && arguments[0] instanceof Double) {
                        this.cacheCommand(method, arguments);
                        break;
                    }
                    throw new LuaException("Expected: " + methodNames[method] + " life<Number>");
                }
                case createStaff: {
                    if (arguments.length >= 4 && arguments[0] instanceof String && arguments[1] instanceof String && arguments[2] instanceof String && arguments[3] instanceof Boolean) {
                        this.cacheCommand(method, arguments);
                        break;
                    }
                    throw new LuaException("Expected: " + methodNames[method] + " treeName<String>, joCode<String>, rgbColor<String>, readOnly<Boolean>");
                }
                case setCode: {
                    if (arguments.length >= 2 && arguments[0] instanceof String && arguments[1] instanceof String) {
                        this.cacheCommand(method, arguments);
                        break;
                    }
                    throw new LuaException("Expected: " + methodNames[method] + " treeName<String>, joCode<String>");
                }
                case growPulse: 
                case killTree: {
                    this.cacheCommand(method, arguments);
                    break;
                }
                case testPoisson: {
                    if (arguments.length >= 3 && arguments[0] instanceof Double && arguments[1] instanceof Double && arguments[2] instanceof Double) {
                        this.cacheCommand(method, arguments);
                        break;
                    }
                    throw new LuaException("Expected: " + methodNames[method] + " radius1<Number>, radius2<Number>, angle<Number>");
                }
                case testPoisson2: {
                    if (arguments.length >= 4 && arguments[0] instanceof Double && arguments[1] instanceof Double && arguments[2] instanceof Double && arguments[3] instanceof Double) {
                        this.cacheCommand(method, arguments);
                        break;
                    }
                    throw new LuaException("Expected: " + methodNames[method] + " radius1<Number>, radius2<Number>, angle<Number>, radius3<Number>");
                }
            }
        }
        return null;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    static {
        for (ComputerMethod method : ComputerMethod.values()) {
            if (!method.include()) continue;
            TileEntityDendroCoil.methodNames[method.ordinal()] = method.toString();
        }
    }

    private class CachedCommand {
        ComputerMethod method;
        Object[] arguments;

        public CachedCommand(int method, Object[] args) {
            this.method = ComputerMethod.values()[method];
            this.arguments = args;
        }
    }

    public static enum ComputerMethod {
        growPulse(false),
        getCode(false),
        setCode(false),
        getTree(false),
        plantTree(false),
        killTree(false),
        getSoilLife(false),
        setSoilLife(false),
        createStaff(false),
        testPoisson(true),
        testPoisson2(true);

        private final boolean debug;

        private ComputerMethod(boolean debug) {
            this.debug = debug;
        }

        public boolean include() {
            return !this.debug || ModConfigs.worldGenDebug;
        }

        public static int countMethods() {
            int count = 0;
            for (ComputerMethod method : ComputerMethod.values()) {
                count += method.include() ? 1 : 0;
            }
            return count;
        }
    }
}

