/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.VanillaTreeData;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.BlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.BlockBackport;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.BlockState;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.EnumHand;
import com.ferreusveritas.dynamictrees.api.backport.IBlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.ItemBackport;
import com.ferreusveritas.dynamictrees.api.backport.SpeciesRegistry;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.cells.ICellSolver;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffect;
import com.ferreusveritas.dynamictrees.api.substances.ISubstanceEffectProvider;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBonsaiPot;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.entities.EntityLingeringEffector;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.potion.SubstanceFertilize;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ColorizerFoliage;

public abstract class DynamicTree {
    private final ResourceLocation name;
    private BlockBranch dynamicBranch;
    private IBlockState primitiveLog;
    private ItemStack primitiveLogItemStack;
    private IBlockState primitiveSapling;
    private BlockDynamicLeaves dynamicLeaves;
    private int leavesSubBlock;
    private int smotherLeavesMax = 4;
    private int lightRequirement = 13;
    protected byte defaultHydration = (byte)4;
    private IBlockState primitiveLeaves;
    private ItemStack primitiveLeavesItemStack;
    private SimpleVoxmap leafCluster;
    private ICellSolver cellSolver = Cells.deciduousSolver;
    private ItemStack stick;
    public boolean canSupportCocoa = false;
    private static final EnumFacing[] upFirst = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};

    public DynamicTree(VanillaTreeData.EnumType treeType) {
        this(new ResourceLocation("dynamictrees", treeType.getName().replace("_", "")), treeType.getMetadata());
        this.simpleVanillaSetup(treeType);
    }

    public DynamicTree(ResourceLocation name, int seq) {
        this.name = name;
        if (seq >= 0) {
            this.setDynamicLeaves(name.func_110624_b(), seq);
        }
        this.setDynamicBranch(new BlockBranch(name + "branch"));
        this.setStick(new ItemStack(Items.field_151055_y));
        this.createLeafCluster();
        this.createSpecies();
    }

    private void simpleVanillaSetup(VanillaTreeData.EnumType wood) {
        this.setPrimitiveLeaves(wood.getLeavesBlockAndMeta(), wood.getLeavesBlockAndMeta().toItemStack());
        this.setPrimitiveLog(wood.getLogBlockAndMeta(), wood.getLogBlockAndMeta().toItemStack());
        this.setPrimitiveSapling(new BlockState(Blocks.field_150345_g, wood.getMetadata()));
        this.simpleVanillaCommonSpecies(wood);
    }

    protected void simpleVanillaCommonSpecies(VanillaTreeData.EnumType wood) {
        Species commonSpecies = this.getCommonSpecies();
        commonSpecies.setDynamicSapling(ModBlocks.blockDynamicSapling.getDefaultState().withMeta(wood.getMetadata()));
        commonSpecies.generateSeed();
    }

    public abstract void createSpecies();

    public abstract void registerSpecies(SpeciesRegistry var1);

    public abstract Species getCommonSpecies();

    public Species getSpeciesForLocation(World access, BlockPos pos) {
        return this.getCommonSpecies();
    }

    public ISubstanceEffect getSubstanceEffect(ItemStack itemStack) {
        if (itemStack.func_77973_b() == Items.field_151100_aR && itemStack.func_77960_j() == 15) {
            return new SubstanceFertilize().setAmount(1).setGrow(true);
        }
        if (itemStack.func_77973_b() instanceof ISubstanceEffectProvider) {
            ISubstanceEffectProvider provider = (ISubstanceEffectProvider)itemStack.func_77973_b();
            return provider.getSubstanceEffect(itemStack);
        }
        return null;
    }

    public boolean applySubstance(World world, BlockPos rootPos, BlockPos hitPos, EntityPlayer player, EnumHand hand, ItemStack itemStack) {
        ISubstanceEffect effect = this.getSubstanceEffect(itemStack);
        if (effect != null) {
            if (effect.isLingering()) {
                CompatHelper.spawnEntity(world, new EntityLingeringEffector(world, rootPos, effect));
                return true;
            }
            return effect.apply(world, rootPos);
        }
        return false;
    }

    public boolean onTreeActivated(World world, BlockPos hitPos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockPos rootPos = DynamicTree.findRootNode(world, hitPos);
        if (rootPos != null) {
            if (heldItem != null && this.applySubstance(world, rootPos, hitPos, player, hand, heldItem)) {
                CompatHelper.consumePlayerItem(player, hand, heldItem);
                return true;
            }
            Species species = DynamicTree.getExactSpecies(world, hitPos);
            if (species != null) {
                species.onTreeActivated(world, rootPos, hitPos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
            }
        }
        return false;
    }

    public List<BlockBackport> getRegisterableBlocks(List<BlockBackport> blockList) {
        blockList.add(this.dynamicBranch);
        return blockList;
    }

    public List<ItemBackport> getRegisterableItems(List<ItemBackport> itemList) {
        Seed seed = this.getCommonSpecies().getSeed();
        if (seed != null) {
            itemList.add(seed);
        }
        return itemList;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public DynamicTree setDynamicLeaves(BlockDynamicLeaves leaves, int sub) {
        this.dynamicLeaves = leaves;
        this.leavesSubBlock = sub;
        this.dynamicLeaves.setTree(this.leavesSubBlock, this);
        return this;
    }

    protected DynamicTree setDynamicLeaves(String modid, int seq) {
        return this.setDynamicLeaves(TreeHelper.getLeavesBlockForSequence(modid, seq), seq & 3);
    }

    public BlockDynamicLeaves getDynamicLeaves() {
        return this.dynamicLeaves;
    }

    public int getDynamicLeavesSub() {
        return this.leavesSubBlock;
    }

    public IBlockState getDynamicLeavesState() {
        return new BlockState((Block)this.getDynamicLeaves()).withProperty(BlockDynamicLeaves.TREE, this.getDynamicLeavesSub());
    }

    public IBlockState getDynamicLeavesState(int hydro) {
        return this.getDynamicLeavesState().withProperty(BlockDynamicLeaves.HYDRO, MathHelper.clamp(hydro, 1, 4));
    }

    protected DynamicTree setDynamicBranch(BlockBranch gBranch) {
        this.dynamicBranch = gBranch;
        this.dynamicBranch.setTree(this);
        return this;
    }

    public BlockBranch getDynamicBranch() {
        return this.dynamicBranch;
    }

    protected DynamicTree setStick(ItemStack itemStack) {
        this.stick = itemStack;
        return this;
    }

    public ItemStack getStick(int qty) {
        return CompatHelper.setStackCount(this.stick.func_77946_l(), MathHelper.clamp(qty, 0, 64));
    }

    protected DynamicTree setPrimitiveLeaves(IBlockState primLeaves, ItemStack primLeavesStack) {
        this.primitiveLeaves = primLeaves;
        this.primitiveLeavesItemStack = primLeavesStack;
        return this;
    }

    public IBlockState getPrimitiveLeaves() {
        return this.primitiveLeaves;
    }

    public ItemStack getPrimitiveLeavesItemStack(int qty) {
        return CompatHelper.setStackCount(this.primitiveLeavesItemStack.func_77946_l(), MathHelper.clamp(qty, 0, 64));
    }

    protected DynamicTree setPrimitiveLog(IBlockState primLog, ItemStack primLogStack) {
        this.primitiveLog = primLog;
        this.primitiveLogItemStack = primLogStack;
        return this;
    }

    public IBlockState getPrimitiveLog() {
        return this.primitiveLog;
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        return CompatHelper.setStackCount(this.primitiveLogItemStack.func_77946_l(), MathHelper.clamp(qty, 0, 64));
    }

    protected DynamicTree setPrimitiveSapling(IBlockState primSapling) {
        this.primitiveSapling = primSapling;
        return this;
    }

    public IBlockState getPrimitiveSapling() {
        return this.primitiveSapling;
    }

    public static Species getExactSpecies(World world, BlockPos pos) {
        BlockPos rootPos = DynamicTree.findRootNode(world, pos);
        if (rootPos != null) {
            BlockRootyDirt rootBlock = (BlockRootyDirt)world.getBlockState(rootPos).getBlock();
            return rootBlock.getSpecies(world, rootPos);
        }
        return null;
    }

    public static BlockPos findRootNode(World world, BlockPos pos) {
        ITreePart treePart = TreeHelper.getSafeTreePart(world, pos);
        if (treePart.isRootNode()) {
            return pos;
        }
        if (treePart.isBranch()) {
            MapSignal signal = treePart.analyse(world, pos, null, new MapSignal());
            if (signal.found) {
                return signal.root;
            }
        }
        return null;
    }

    public ICell getCellForBranch(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, BlockBranch branch) {
        return branch.getRadius(blockState) == 1 ? Cells.branchCell : Cells.nullCell;
    }

    @SideOnly(value=Side.CLIENT)
    public int foliageColorMultiplier(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        if (blockAccess != null) {
            return Blocks.field_150361_u.func_149720_d((net.minecraft.world.IBlockAccess)blockAccess, pos.getX(), pos.getY(), pos.getZ());
        }
        return ColorizerFoliage.func_77468_c();
    }

    public void setSmotherLeavesMax(int smotherLeavesMax) {
        this.smotherLeavesMax = smotherLeavesMax;
    }

    public int getSmotherLeavesMax() {
        return this.smotherLeavesMax;
    }

    public int getLightRequirement() {
        return this.lightRequirement;
    }

    public byte getDefaultHydration() {
        return this.defaultHydration;
    }

    public void setCellSolver(ICellSolver solver) {
        this.cellSolver = solver;
    }

    public ICellSolver getCellSolver() {
        return this.cellSolver;
    }

    public void setLeafCluster(SimpleVoxmap leafCluster) {
        this.leafCluster = leafCluster;
    }

    public SimpleVoxmap getLeafCluster() {
        return this.leafCluster;
    }

    public void createLeafCluster() {
        this.leafCluster = new SimpleVoxmap(5, 4, 5, new byte[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 3, 4, 3, 1, 1, 4, 0, 4, 1, 1, 3, 4, 3, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 2, 3, 2, 1, 1, 3, 4, 3, 1, 1, 2, 3, 2, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(2, 1, 2));
    }

    public byte getLeafClusterPoint(BlockPos twigPos, BlockPos leafPos) {
        return this.leafCluster.getVoxel(twigPos, leafPos);
    }

    public boolean isCompatibleDynamicLeaves(IBlockAccess blockAccess, BlockPos pos) {
        IBlockState state = blockAccess.getBlockState(pos);
        ITreePart treePart = TreeHelper.getTreePart(state);
        if (treePart != null && treePart instanceof BlockDynamicLeaves) {
            return this == ((BlockDynamicLeaves)treePart).getTree(state);
        }
        return false;
    }

    public boolean isCompatibleDynamicLeaves(Block leaves, int sub) {
        return leaves == this.getDynamicLeaves() && sub == this.getDynamicLeavesSub();
    }

    public boolean isCompatibleVanillaLeaves(BlockAccess blockAccess, BlockPos pos) {
        return this.getPrimitiveLeaves().matches(blockAccess.getBlockState(pos), 3);
    }

    public boolean isCompatibleGenericLeaves(BlockAccess blockAccess, BlockPos pos) {
        return this.isCompatibleDynamicLeaves(blockAccess, pos) || this.isCompatibleVanillaLeaves(blockAccess, pos);
    }

    public ICell getCellForLeaves(int hydro) {
        return Cells.normalCells[hydro];
    }

    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random) {
        if (radius <= 1) {
            for (EnumFacing dir : upFirst) {
                if (!this.getDynamicLeaves().growLeaves(world, this, pos.offset(dir), 0)) continue;
                return false;
            }
        }
        world.setBlockToAir(pos);
        return true;
    }

    public BlockBonsaiPot getBonzaiPot() {
        return ModBlocks.blockBonsaiPot;
    }

    public String toString() {
        return this.getName().toString();
    }
}

