/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.VanillaTreeData;
import com.ferreusveritas.dynamictrees.api.backport.Biome;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.IBlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.SpeciesRegistry;
import com.ferreusveritas.dynamictrees.api.cells.Cells;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.cells.CellAcaciaLeaf;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import net.minecraftforge.common.BiomeDictionary;

public class TreeAcacia
extends DynamicTree {
    Species species;
    protected static final ICell acaciaBranch = new ICell(){
        final int[] map = new int[]{0, 3, 5, 5, 5, 5};

        @Override
        public int getValue() {
            return 5;
        }

        @Override
        public int getValueFromSide(EnumFacing side) {
            return this.map[side.ordinal()];
        }
    };
    protected static final ICell[] acaciaLeafCells = new ICell[]{Cells.nullCell, new CellAcaciaLeaf(1), new CellAcaciaLeaf(2), new CellAcaciaLeaf(3), new CellAcaciaLeaf(4)};

    public TreeAcacia() {
        super(VanillaTreeData.EnumType.ACACIA);
        this.setCellSolver(Cells.acaciaSolver);
        this.setSmotherLeavesMax(2);
    }

    @Override
    public void createSpecies() {
        this.species = new SpeciesAcacia((DynamicTree)this);
    }

    @Override
    public void registerSpecies(SpeciesRegistry speciesRegistry) {
        speciesRegistry.register(this.species);
    }

    @Override
    public Species getCommonSpecies() {
        return this.species;
    }

    @Override
    public ICell getCellForBranch(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, BlockBranch branch) {
        return branch.getRadius(blockState) == 1 ? acaciaBranch : Cells.nullCell;
    }

    @Override
    public ICell getCellForLeaves(int hydro) {
        return acaciaLeafCells[hydro];
    }

    @Override
    public void createLeafCluster() {
        this.setLeafCluster(new SimpleVoxmap(7, 2, 7, new byte[]{0, 0, 1, 1, 1, 0, 0, 0, 1, 2, 2, 2, 1, 0, 1, 2, 3, 4, 3, 2, 1, 1, 2, 4, 0, 4, 2, 1, 1, 2, 3, 4, 3, 2, 1, 0, 1, 2, 2, 2, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 2, 2, 2, 1, 0, 0, 1, 2, 2, 2, 1, 0, 0, 1, 2, 2, 2, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}).setCenter(new BlockPos(3, 0, 3)));
    }

    public class SpeciesAcacia
    extends Species {
        SpeciesAcacia(DynamicTree treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.15f, 12.0f, 0, 3, 0.7f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.25f);
            this.envFactor(BiomeDictionary.Type.NETHER, 0.75f);
            this.envFactor(BiomeDictionary.Type.WET, 0.75f);
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return CompatHelper.biomeHasType(biome, BiomeDictionary.Type.SAVANNA);
        }
    }
}

