/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.VanillaTreeData;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.Biome;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.IBlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.SpeciesRegistry;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class TreeBirch
extends DynamicTree {
    Species species;

    public TreeBirch() {
        super(VanillaTreeData.EnumType.BIRCH);
    }

    @Override
    public void createSpecies() {
        this.species = new SpeciesBirch((DynamicTree)this);
    }

    @Override
    public void registerSpecies(SpeciesRegistry speciesRegistry) {
        speciesRegistry.register(this.species);
    }

    @Override
    public Species getCommonSpecies() {
        return this.species;
    }

    @Override
    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random) {
        if (super.rot(world, pos, neighborCount, radius, random)) {
            if (radius > 4 && TreeHelper.isRootyDirt(world, pos.down()) && world.getLightFor(EnumSkyBlock.Sky, pos) < 4) {
                world.setBlockState(pos, (Block)Blocks.field_150338_P);
                world.setBlockState(pos.down(), Blocks.field_150346_d);
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int foliageColorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ColorizerFoliage.func_77469_b();
    }

    public class SpeciesBirch
    extends Species {
        SpeciesBirch(DynamicTree treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.1f, 14.0f, 4, 4, 1.25f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return SpeciesBirch.isOneOfBiomes(biome, BiomeGenBase.field_150583_P, BiomeGenBase.field_150582_Q);
        }
    }
}

