/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.VanillaTreeData;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.Biome;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.IBlockAccess;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.SpeciesRegistry;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.genfeatures.GenFeatureVine;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class TreeOak
extends DynamicTree {
    Species commonSpecies;
    Species swampSpecies;
    Species appleSpecies;

    public TreeOak() {
        super(VanillaTreeData.EnumType.OAK);
    }

    @Override
    public void createSpecies() {
        this.commonSpecies = new SpeciesOak((DynamicTree)this);
        this.swampSpecies = new SpeciesSwampOak((DynamicTree)this);
        this.appleSpecies = new SpeciesAppleOak((DynamicTree)this);
    }

    @Override
    public void registerSpecies(SpeciesRegistry speciesRegistry) {
        speciesRegistry.register(this.commonSpecies);
        speciesRegistry.register(this.swampSpecies);
        speciesRegistry.register(this.appleSpecies);
    }

    @Override
    public Species getCommonSpecies() {
        return this.commonSpecies;
    }

    @Override
    public Species getSpeciesForLocation(World world, BlockPos pos) {
        if (CompatHelper.biomeHasType(world.getBiome(pos), BiomeDictionary.Type.SWAMP)) {
            return this.swampSpecies;
        }
        return this.getCommonSpecies();
    }

    @Override
    public boolean rot(World world, BlockPos pos, int neighborCount, int radius, Random random) {
        if (super.rot(world, pos, neighborCount, radius, random)) {
            if (radius > 4 && TreeHelper.isRootyDirt(world, pos.down()) && world.getLightFor(EnumSkyBlock.Sky, pos) < 4) {
                world.setBlockState(pos, random.nextInt(3) == 0 ? ModBlocks.blockStates.redMushroom : ModBlocks.blockStates.brownMushroom);
                world.setBlockState(pos.down(), ModBlocks.blockStates.podzol);
            }
            return true;
        }
        return false;
    }

    public class SpeciesAppleOak
    extends Species {
        public SpeciesAppleOak(DynamicTree treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), "apple"), treeFamily);
            this.setBasicGrowingParameters(0.4f, 10.0f, 1, 4, 0.7f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.75f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.25f);
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return biome.base() == BiomeGenBase.field_76772_c;
        }

        @Override
        public ArrayList<ItemStack> getDrops(IBlockAccess blockAccess, BlockPos pos, int chance, ArrayList<ItemStack> drops) {
            return TreeOak.this.commonSpecies.getDrops(blockAccess, pos, chance, drops);
        }

        @Override
        public void postGeneration(World world, BlockPos pos, Biome biome, int radius, List<BlockPos> endPoints, boolean worldGen) {
            super.postGeneration(world, pos, biome, radius, endPoints, worldGen);
        }
    }

    public class SpeciesSwampOak
    extends Species {
        GenFeatureVine vineGen;

        SpeciesSwampOak(DynamicTree treeFamily) {
            super(new ResourceLocation(treeFamily.getName().func_110624_b(), treeFamily.getName().func_110623_a() + "swamp"), treeFamily);
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.8f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.vineGen = new GenFeatureVine(this).setMaxLength(7).setVerSpread(30.0f).setRayDistance(6.0f);
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return SpeciesSwampOak.isOneOfBiomes(biome, BiomeGenBase.field_76780_h);
        }

        @Override
        public boolean isAcceptableSoilForWorldgen(World world, BlockPos pos, IBlockState soilBlockState) {
            BlockPos down;
            Biome biome;
            if (soilBlockState.getBlock() == Blocks.field_150355_j && CompatHelper.biomeHasType(biome = world.getBiome(pos), BiomeDictionary.Type.SWAMP) && this.isAcceptableSoil(world, down = pos.down(), world.getBlockState(down))) {
                return true;
            }
            return super.isAcceptableSoilForWorldgen(world, pos, soilBlockState);
        }

        @Override
        public ArrayList<ItemStack> getDrops(IBlockAccess blockAccess, BlockPos pos, int chance, ArrayList<ItemStack> drops) {
            return TreeOak.this.commonSpecies.getDrops(blockAccess, pos, chance, drops);
        }

        @Override
        public ItemStack getSeedStack(int qty) {
            return TreeOak.this.commonSpecies.getSeedStack(qty);
        }

        @Override
        public Seed getSeed() {
            return TreeOak.this.commonSpecies.getSeed();
        }

        @Override
        public void postGeneration(World world, BlockPos rootPos, Biome biome, int radius, List<BlockPos> endPoints, boolean worldGen) {
            super.postGeneration(world, rootPos, biome, radius, endPoints, worldGen);
            this.vineGen.setQuantity(5).gen(world, rootPos.up(), endPoints);
        }
    }

    public class SpeciesOak
    extends Species {
        SpeciesOak(DynamicTree treeFamily) {
            super(treeFamily.getName(), treeFamily);
            this.setBasicGrowingParameters(0.3f, 12.0f, this.upProbability, this.lowestBranchHeight, 0.8f);
            this.envFactor(BiomeDictionary.Type.COLD, 0.75f);
            this.envFactor(BiomeDictionary.Type.HOT, 0.5f);
            this.envFactor(BiomeDictionary.Type.DRY, 0.5f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
        }

        @Override
        public boolean isBiomePerfect(Biome biome) {
            return SpeciesOak.isOneOfBiomes(biome, BiomeGenBase.field_76767_f, BiomeGenBase.field_76785_t);
        }

        @Override
        public ArrayList<ItemStack> getDrops(IBlockAccess blockAccess, BlockPos pos, int chance, ArrayList<ItemStack> drops) {
            Random rand;
            Random random = rand = blockAccess instanceof World ? ((World)blockAccess).rand : new Random();
            if (rand.nextInt(chance) == 0) {
                drops.add(new ItemStack(Items.field_151034_e, 1, 0));
            }
            return drops;
        }
    }
}

