/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.ChunkPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;

public class BlockBounds {
    public static final BlockBounds INVALID = new BlockBounds();
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private boolean valid = false;

    public BlockBounds() {
        this.valid = false;
    }

    public BlockBounds(BlockPos pos) {
        this.init(pos);
    }

    public BlockBounds(ChunkPos cPos) {
        this.init(cPos);
    }

    public void init(ChunkPos cPos) {
        this.minX = cPos.getXStart();
        this.minY = 0;
        this.minZ = cPos.getZStart();
        this.maxX = cPos.getXEnd();
        this.maxY = 255;
        this.maxZ = cPos.getZEnd();
        this.valid = true;
    }

    public void init(BlockPos pos) {
        this.minX = this.maxX = pos.getX();
        this.minY = this.maxY = pos.getY();
        this.minZ = this.maxZ = pos.getZ();
        this.valid = true;
    }

    public void union(BlockPos pos) {
        if (!this.valid) {
            this.init(pos);
            return;
        }
        if (pos.getX() < this.minX) {
            this.minX = pos.getX();
        } else if (pos.getX() > this.maxX) {
            this.maxX = pos.getX();
        }
        if (pos.getY() < this.minY) {
            this.minY = pos.getY();
        } else if (pos.getY() > this.maxY) {
            this.maxY = pos.getY();
        }
        if (pos.getZ() < this.minZ) {
            this.minZ = pos.getZ();
        } else if (pos.getZ() > this.maxZ) {
            this.maxZ = pos.getZ();
        }
    }

    public boolean inBounds(BlockPos pos) {
        return this.valid && pos.getX() >= this.minX && pos.getX() <= this.maxX && pos.getZ() >= this.minZ && pos.getZ() <= this.maxZ;
    }

    public BlockPos getMin() {
        return new BlockPos(this.minX, this.minY, this.minZ);
    }

    public BlockPos getMax() {
        return new BlockPos(this.maxX, this.maxY, this.maxZ);
    }

    public BlockBounds shrink(EnumFacing dir, int amount) {
        switch (dir) {
            case DOWN: {
                this.minY += amount;
                break;
            }
            case UP: {
                this.maxY -= amount;
                break;
            }
            case NORTH: {
                this.minZ += amount;
                break;
            }
            case SOUTH: {
                this.maxZ -= amount;
                break;
            }
            case WEST: {
                this.minX += amount;
                break;
            }
            case EAST: {
                this.maxX -= amount;
            }
        }
        return this;
    }

    public BlockBounds shrinkAll() {
        return this.shrinkAll(1);
    }

    public BlockBounds shrinkAll(int amount) {
        for (EnumFacing dir : EnumFacing.VALUES) {
            this.shrink(dir, amount);
        }
        return this;
    }

    public BlockBounds shrinkHorizontal() {
        return this.shrinkHorizontal(1);
    }

    public BlockBounds shrinkHorizontal(int amount) {
        for (EnumFacing dir : EnumFacing.HORIZONTALS) {
            this.shrink(dir, amount);
        }
        return this;
    }
}

