/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.util;

import com.ferreusveritas.dynamictrees.api.backport.Biome;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumHand;
import com.ferreusveritas.dynamictrees.api.substances.IEmptiable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class CompatHelper {
    public static boolean spawnEntity(com.ferreusveritas.dynamictrees.api.backport.World world, Entity entity) {
        return world.real().func_72838_d(entity);
    }

    public static com.ferreusveritas.dynamictrees.api.backport.World getEntityWorld(Entity entity) {
        return new com.ferreusveritas.dynamictrees.api.backport.World(entity.field_70170_p);
    }

    public static ItemStack getEntityItem(EntityItem entityItem) {
        return entityItem.func_92059_d();
    }

    public static void spawnItemStackAsEntity(World world, BlockPos pos, ItemStack stack) {
        if (!world.field_72995_K && !world.restoringBlockSnapshots) {
            double x = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double y = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double z = (double)(world.field_73012_v.nextFloat() * 0.5f) + 0.25;
            EntityItem entityitem = new EntityItem(world, (double)pos.getX() + x, (double)pos.getY() + y, (double)pos.getZ() + z, stack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void spawnItemStackAsEntity(com.ferreusveritas.dynamictrees.api.backport.World world, BlockPos pos, ItemStack stack) {
        CompatHelper.spawnItemStackAsEntity(world.real(), pos, stack);
    }

    public static boolean biomeHasType(Biome biome, BiomeDictionary.Type type) {
        return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome.base(), (BiomeDictionary.Type)type);
    }

    public static int getBiomeTreesPerChunk(Biome biome) {
        return biome.base().field_76760_I.field_76832_z;
    }

    public static int getStackCount(ItemStack stack) {
        return CompatHelper.isValid(stack) ? stack.field_77994_a : 0;
    }

    public static ItemStack setStackCount(ItemStack stack, int size) {
        if (CompatHelper.isValid(stack)) {
            stack.field_77994_a = size;
            return stack;
        }
        return CompatHelper.emptyStack();
    }

    public static ItemStack growStack(ItemStack stack, int quantity) {
        if (CompatHelper.isValid(stack)) {
            stack.field_77994_a += quantity;
            return stack;
        }
        return CompatHelper.emptyStack();
    }

    public static ItemStack shrinkStack(ItemStack stack, int quantity) {
        return CompatHelper.growStack(stack, -quantity);
    }

    public static ItemStack emptyStack() {
        return null;
    }

    public static boolean isValid(ItemStack stack) {
        return stack != null && stack != CompatHelper.emptyStack();
    }

    public static boolean isStackEmpty(ItemStack stack) {
        return CompatHelper.getStackCount(stack) == 0;
    }

    public static void consumePlayerItem(EntityPlayer player, EnumHand hand, ItemStack heldItem) {
        if (!player.field_71075_bZ.field_75098_d) {
            if (heldItem.func_77973_b() instanceof IEmptiable) {
                IEmptiable emptiable = (IEmptiable)heldItem.func_77973_b();
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = emptiable.getEmptyContainer();
            } else if (heldItem.func_77973_b() == Items.field_151068_bn) {
                player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = new ItemStack(Items.field_151069_bo);
            } else {
                CompatHelper.shrinkStack(heldItem, 1);
            }
        }
    }
}

