/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.backport.Biome;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeSpeciesSelector;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenHills;
import net.minecraftforge.common.BiomeDictionary;

public class DefaultBiomeTreeSelector
implements IBiomeSpeciesSelector {
    public static final int MUTATED = 128;
    private Species oak;
    private Species birch;
    private Species spruce;
    private Species acacia;
    private Species jungle;
    private Species darkoak;
    private Species oakswamp;
    private StaticDecision staticOakDecision;
    private StaticDecision staticSpruceDecision;
    private StaticDecision staticBirchDecision;
    private StaticDecision staticDarkOakDecision;
    HashMap<Integer, ITreeSelector> fastTreeLookup = new HashMap();

    @Override
    public void init() {
        this.oak = TreeRegistry.findSpeciesSloppy("oak");
        this.birch = TreeRegistry.findSpeciesSloppy("birch");
        this.spruce = TreeRegistry.findSpeciesSloppy("spruce");
        this.acacia = TreeRegistry.findSpeciesSloppy("acacia");
        this.jungle = TreeRegistry.findSpeciesSloppy("jungle");
        this.darkoak = TreeRegistry.findSpeciesSloppy("darkoak");
        this.oakswamp = TreeRegistry.findSpeciesSloppy("oakswamp");
        this.staticOakDecision = new StaticDecision(new IBiomeSpeciesSelector.Decision(this.oak));
        this.staticSpruceDecision = new StaticDecision(new IBiomeSpeciesSelector.Decision(this.spruce));
        this.staticBirchDecision = new StaticDecision(new IBiomeSpeciesSelector.Decision(this.birch));
        this.staticDarkOakDecision = new StaticDecision(new IBiomeSpeciesSelector.Decision(this.darkoak));
    }

    @Override
    public String getName() {
        return "dynamictrees:default";
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public IBiomeSpeciesSelector.Decision getSpecies(World world, Biome biome, BlockPos pos, IBlockState dirt, Random random) {
        ITreeSelector select;
        int biomeId = Biome.getIdForBiome(biome);
        if (this.fastTreeLookup.containsKey(biomeId)) {
            select = this.fastTreeLookup.get(biomeId);
        } else {
            select = biome.base() instanceof BiomeGenHills ? new RandomDecision(world.rand).addSpecies(this.oak, 1).addSpecies(this.spruce, 2).end() : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.FOREST) ? (biome.biomeID == BiomeGenBase.field_150578_U.field_76756_M + 128 || biome.biomeID == BiomeGenBase.field_150581_V.field_76756_M + 128 ? this.staticSpruceDecision : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.CONIFEROUS) ? this.staticSpruceDecision : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.SPOOKY) ? this.staticDarkOakDecision : (Species.isOneOfBiomes(biome, BiomeGenBase.field_150583_P, BiomeGenBase.field_150582_Q) ? this.staticBirchDecision : new RandomDecision(world.rand).addSpecies(this.oak, 4).addSpecies(this.birch, 1).end())))) : (biome.biomeID == BiomeGenBase.field_150585_R.field_76756_M + 128 ? this.staticDarkOakDecision : (biome.base() == BiomeGenBase.field_150607_aa ? this.staticOakDecision : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.JUNGLE) ? new StaticDecision(new IBiomeSpeciesSelector.Decision(this.jungle)) : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.SAVANNA) ? new StaticDecision(new IBiomeSpeciesSelector.Decision(this.acacia)) : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.SWAMP) ? new StaticDecision(new IBiomeSpeciesSelector.Decision(this.oakswamp)) : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.SANDY) ? new StaticDecision(new IBiomeSpeciesSelector.Decision()) : (CompatHelper.biomeHasType(biome, BiomeDictionary.Type.WASTELAND) ? new StaticDecision(new IBiomeSpeciesSelector.Decision()) : this.staticOakDecision))))))));
            this.fastTreeLookup.put(biomeId, select);
        }
        return select.getDecision();
    }

    private class RandomDecision
    implements ITreeSelector {
        ArrayList<IBiomeSpeciesSelector.Decision> table = new ArrayList();
        Random rand;

        public RandomDecision(Random rand) {
            this.rand = rand;
        }

        public RandomDecision addSpecies(Species species, int weight) {
            while (weight-- > 0) {
                this.table.add(new IBiomeSpeciesSelector.Decision(species));
            }
            return this;
        }

        public RandomDecision end() {
            this.table.trimToSize();
            return this;
        }

        @Override
        public IBiomeSpeciesSelector.Decision getDecision() {
            return this.table.get(this.rand.nextInt(this.table.size()));
        }
    }

    private class StaticDecision
    implements ITreeSelector {
        IBiomeSpeciesSelector.Decision decision;

        public StaticDecision(IBiomeSpeciesSelector.Decision decision) {
            this.decision = decision;
        }

        @Override
        public IBiomeSpeciesSelector.Decision getDecision() {
            return this.decision;
        }
    }

    private static interface ITreeSelector {
        public IBiomeSpeciesSelector.Decision getDecision();
    }
}

