/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.backport.Biome;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.backport.World;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.blocks.BlockRootyDirt;
import com.ferreusveritas.dynamictrees.inspectors.NodeCoder;
import com.ferreusveritas.dynamictrees.inspectors.NodeFindEnds;
import com.ferreusveritas.dynamictrees.inspectors.NodeInflator;
import com.ferreusveritas.dynamictrees.trees.DynamicTree;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;

public class JoCode {
    private static final String base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final byte forkCode = 6;
    private static final byte returnCode = 7;
    public ArrayList<Byte> instructions;
    private boolean careful = false;
    private int[][] dirmap = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 3, 2, 5, 4, 6, 7}, {0, 1, 5, 4, 2, 3, 6, 7}, {0, 1, 4, 5, 3, 2, 6, 7}};
    private int[] facingMap = this.dirmap[2];
    private int[] unfacingMap = this.dirmap[2];

    public JoCode() {
        this.instructions = new ArrayList();
    }

    public JoCode(String code) {
        this.loadCode(code);
    }

    public JoCode loadCode(String code) {
        this.instructions = JoCode.decode(code);
        return this;
    }

    public JoCode setCareful(boolean c) {
        this.careful = c;
        return this;
    }

    private int getCode(int pos) {
        return this.unfacingMap[this.instructions.get(pos)];
    }

    public JoCode setFacing(EnumFacing facing) {
        int faceNum = facing.ordinal();
        this.facingMap = this.dirmap[faceNum];
        faceNum = faceNum == 4 ? 5 : (faceNum == 5 ? 4 : faceNum);
        this.unfacingMap = this.dirmap[faceNum];
        return this;
    }

    public JoCode rotate(EnumFacing dir) {
        this.setFacing(dir);
        for (int c = 0; c < this.instructions.size(); ++c) {
            this.instructions.set(c, (byte)this.facingMap[this.instructions.get(c)]);
        }
        return this;
    }

    public void generate(World world, Species species, BlockPos rootPos, Biome biome, EnumFacing facing, int radius) {
        IBlockState initialState = world.getBlockState(rootPos);
        world.setBlockState(rootPos, species.getRootyDirtBlock().getDefaultState().withProperty(BlockRootyDirt.LIFE, 0));
        radius = MathHelper.clamp(radius, 2, 8);
        BlockPos treePos = rootPos.up();
        this.setFacing(facing);
        this.generateFork(world, species, 0, rootPos, false);
        BlockBranch branch = TreeHelper.getBranch(world, treePos);
        if (branch != null) {
            BlockPos cellPos;
            SimpleVoxmap leafMap = new SimpleVoxmap(radius * 2 + 1, 32, radius * 2 + 1).setMapAndCenter(treePos, new BlockPos(radius, 0, radius));
            NodeInflator inflator = new NodeInflator(species, leafMap);
            NodeFindEnds endFinder = new NodeFindEnds();
            MapSignal signal = new MapSignal(inflator, endFinder);
            branch.analyse(world, treePos, EnumFacing.DOWN, signal);
            List<BlockPos> endPoints = endFinder.getEnds();
            this.smother(leafMap, branch.getTree());
            SafeChunkBounds safeBounds = new SafeChunkBounds(world, rootPos);
            IBlockState leavesState = branch.getTree().getDynamicLeavesState();
            for (SimpleVoxmap.Cell cell : leafMap.getAllNonZeroCells((byte)15)) {
                cellPos = cell.getPos();
                if (safeBounds.inBounds(cellPos)) {
                    IBlockState testBlockState = world.getBlockState(cellPos);
                    Block testBlock = testBlockState.getBlock();
                    if (!testBlock.isReplaceable((IBlockAccess)world, cellPos.getX(), cellPos.getY(), cellPos.getZ())) continue;
                    world.setBlockState(cellPos, leavesState.withProperty(BlockDynamicLeaves.HYDRO, MathHelper.clamp(cell.getValue(), 1, 4)), this.careful ? 2 : 0);
                    continue;
                }
                leafMap.setVoxel(cellPos, (byte)0);
            }
            safeBounds.setShrink(1);
            for (SimpleVoxmap.Cell cell : leafMap.getAllNonZeroCells((byte)15)) {
                cellPos = cell.getPos();
                if (safeBounds.inBounds(cellPos)) continue;
                leafMap.setVoxel(cellPos, (byte)0);
            }
            TreeHelper.ageVolume(world, treePos, radius, 32, leafMap, 3);
            species.handleRot(world, endPoints, rootPos, treePos, 0, true);
            species.postGeneration(world, rootPos, biome, radius, endPoints, !this.careful);
        } else {
            world.setBlockState(rootPos, initialState, this.careful ? 3 : 2);
        }
    }

    private int generateFork(World world, Species species, int codePos, BlockPos pos, boolean disabled) {
        while (codePos < this.instructions.size()) {
            int code = this.getCode(codePos);
            if (code == 6) {
                codePos = this.generateFork(world, species, codePos + 1, pos, disabled);
                continue;
            }
            if (code == 7) {
                return codePos + 1;
            }
            EnumFacing dir = EnumFacing.getFront(code);
            pos = pos.offset(dir);
            if (!disabled) {
                if (world.getBlockState(pos).getBlock().isReplaceable((IBlockAccess)world, pos.getX(), pos.getY(), pos.getZ()) && (!this.careful || this.isClearOfNearbyBranches(world, pos, dir.getOpposite()))) {
                    world.setBlockState(pos, species.getTree().getDynamicBranch().getDefaultState(), this.careful ? 3 : 2);
                } else {
                    disabled = true;
                }
            }
            ++codePos;
        }
        return codePos;
    }

    private void smother(SimpleVoxmap leafMap, DynamicTree tree) {
        BlockPos saveCenter = leafMap.getCenter();
        leafMap.setCenter(new BlockPos(0, 0, 0));
        for (int startY = leafMap.getLenY() - 1; startY >= 0 && !leafMap.isYTouched(startY); --startY) {
        }
        for (int iz = 0; iz < leafMap.getLenZ(); ++iz) {
            for (int ix = 0; ix < leafMap.getLenX(); ++ix) {
                int count = 0;
                for (int iy = startY; iy >= 0; --iy) {
                    byte v = leafMap.getVoxel(new BlockPos(ix, iy, iz));
                    if (v == 0) {
                        count = 0;
                        continue;
                    }
                    if ((v & 0xF) != 0) {
                        if (++count <= tree.getSmotherLeavesMax()) continue;
                        leafMap.setVoxel(new BlockPos(ix, iy, iz), (byte)0);
                        continue;
                    }
                    if ((v & 0x10) == 0) continue;
                    ++count;
                    leafMap.setVoxel(new BlockPos(ix, iy + 1, iz), (byte)4);
                }
            }
        }
        leafMap.setCenter(saveCenter);
    }

    private boolean isClearOfNearbyBranches(World world, BlockPos pos, EnumFacing except) {
        for (EnumFacing dir : EnumFacing.VALUES) {
            if (dir == except || TreeHelper.getBranch(world, pos.offset(dir)) == null) continue;
            return false;
        }
        return true;
    }

    public JoCode buildFromTree(World world, BlockPos pos, EnumFacing facing) {
        BlockBranch branch = TreeHelper.getBranch(world, pos.up());
        if (branch != null) {
            NodeCoder coder = new NodeCoder();
            branch.analyse(world, pos, EnumFacing.DOWN, new MapSignal(coder));
            coder.compile(this, facing);
            this.instructions.trimToSize();
        }
        return this;
    }

    public JoCode buildFromTree(World world, BlockPos pos) {
        return this.buildFromTree(world, pos, EnumFacing.NORTH);
    }

    public static String encode(ArrayList<Byte> instructions) {
        if ((instructions.size() & 1) == 1) {
            instructions.add((byte)7);
        }
        String code = "";
        for (int b = 0; b < instructions.size(); b += 2) {
            code = code + base64.charAt(instructions.get(b) << 3 | instructions.get(b + 1));
        }
        return code;
    }

    public static ArrayList<Byte> decode(String code) {
        ArrayList<Byte> instructions = new ArrayList<Byte>(code.length() * 2);
        for (int i = 0; i < code.length(); ++i) {
            int sixbits = base64.indexOf(code.charAt(i));
            if (sixbits == -1) continue;
            instructions.add((byte)(sixbits >> 3));
            instructions.add((byte)(sixbits & 7));
        }
        return instructions;
    }

    public void addDirection(byte dir) {
        if (dir >= 0) {
            this.instructions.add((byte)(dir & 7));
        }
    }

    public void addReturn() {
        this.instructions.add((byte)7);
    }

    public void addFork() {
        this.instructions.add((byte)6);
    }

    public String toString() {
        return JoCode.encode(this.instructions);
    }
}

