/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.backport.EnumFacing;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.MathHelper;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TreeCodeStore {
    ArrayList<ArrayList<JoCode>> store = new ArrayList(7);
    Species species;

    public TreeCodeStore(Species tree) {
        this.species = tree;
        for (int i = 0; i < 7; ++i) {
            this.store.add(new ArrayList());
        }
    }

    private ArrayList<JoCode> getListForRadius(int radius) {
        radius = MathHelper.clamp(radius, 2, 8);
        return this.store.get(radius - 2);
    }

    public void addCodesFromFile(String filename) {
        block6: {
            try {
                Logger.getLogger("dynamictrees").log(Level.CONFIG, "Loading Tree Codes for species \"" + this.species + "\" from file: " + filename);
                InputStream stream = this.getClass().getClassLoader().getResourceAsStream(filename);
                if (stream != null) {
                    String line;
                    InputStreamReader streamReader = new InputStreamReader(stream, "UTF-8");
                    BufferedReader readIn = new BufferedReader(streamReader);
                    while ((line = readIn.readLine()) != null) {
                        if (line.length() < 3 || line.charAt(0) == '#') continue;
                        String[] split = line.split(":");
                        this.addCode(Integer.valueOf(split[0]), split[1]);
                    }
                    break block6;
                }
                throw new FileNotFoundException(filename);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addCode(int radius, String code) {
        JoCode joCode = new JoCode(code).setCareful(false);
        this.getListForRadius(radius).add(joCode);
    }

    private void collectWorldGenCodes(int radius, JoCode joCode) {
        EnumFacing[] dirs = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
        ArrayList<String> arr = new ArrayList<String>();
        for (EnumFacing dir : dirs) {
            arr.add(joCode.rotate(dir).toString());
        }
        Collections.sort(arr);
        System.out.println(this.species + ":" + radius + ":" + (String)arr.get(0));
    }

    public JoCode getRandomCode(int radius, Random rand) {
        ArrayList<JoCode> list = this.getListForRadius(radius);
        if (!list.isEmpty()) {
            return list.get(rand.nextInt(list.size()));
        }
        return null;
    }
}

