/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.ModConfigs;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.WorldGenRegistry;
import com.ferreusveritas.dynamictrees.api.backport.Biome;
import com.ferreusveritas.dynamictrees.api.backport.BlockPos;
import com.ferreusveritas.dynamictrees.api.backport.BlockState;
import com.ferreusveritas.dynamictrees.api.backport.EnumDyeColor;
import com.ferreusveritas.dynamictrees.api.backport.IBlockState;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeDensityProvider;
import com.ferreusveritas.dynamictrees.api.worldgen.IBiomeSpeciesSelector;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.Circle;
import com.ferreusveritas.dynamictrees.util.CompatHelper;
import com.ferreusveritas.dynamictrees.worldgen.BiomeRadiusCoordinator;
import com.ferreusveritas.dynamictrees.worldgen.BiomeTreeHandler;
import com.ferreusveritas.dynamictrees.worldgen.ChunkCircleManager;
import com.ferreusveritas.dynamictrees.worldgen.RandomXOR;
import com.ferreusveritas.dynamictrees.worldgen.TreeCodeStore;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraftforge.common.BiomeDictionary;

public class TreeGenerator
implements IWorldGenerator {
    private static TreeGenerator INSTANCE;
    public BiomeTreeHandler biomeTreeHandler = new BiomeTreeHandler();
    public BiomeRadiusCoordinator radiusCoordinator = new BiomeRadiusCoordinator(this.biomeTreeHandler);
    public TreeCodeStore codeStore;
    protected ChunkCircleManager circleMan = new ChunkCircleManager(this.radiusCoordinator);
    protected RandomXOR random = new RandomXOR();

    public static TreeGenerator getTreeGenerator() {
        return INSTANCE;
    }

    public static void preInit() {
        if (WorldGenRegistry.isWorldGenEnabled()) {
            INSTANCE = new TreeGenerator();
        }
    }

    public static void init() {
        if (WorldGenRegistry.isWorldGenEnabled()) {
            TreeGenerator.INSTANCE.biomeTreeHandler.init();
        }
    }

    public void onWorldUnload() {
        this.circleMan = new ChunkCircleManager(this.radiusCoordinator);
    }

    public ChunkCircleManager getChunkCircleManager() {
        return this.circleMan;
    }

    public void generate(Random randomUnused, int chunkX, int chunkZ, World _world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        com.ferreusveritas.dynamictrees.api.backport.World world = new com.ferreusveritas.dynamictrees.api.backport.World(_world);
        this.random.setXOR(new BlockPos(chunkX, 0, chunkZ));
        switch (world.real().field_73011_w.field_76574_g) {
            case 0: {
                this.generateOverworld(this.random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                break;
            }
            case -1: {
                break;
            }
        }
    }

    private void generateOverworld(Random random, int chunkX, int chunkZ, com.ferreusveritas.dynamictrees.api.backport.World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        ArrayList<Circle> circles = this.circleMan.getCircles(world, random, chunkX, chunkZ);
        for (Circle c : circles) {
            this.makeTree(world, c);
        }
        BlockPos pos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        if (CompatHelper.biomeHasType(world.getBiome(pos), BiomeDictionary.Type.SPOOKY)) {
            this.roofedForestCompensation(world, random, pos);
        }
    }

    public void roofedForestCompensation(com.ferreusveritas.dynamictrees.api.backport.World world, Random random, BlockPos pos) {
        for (int xi = 0; xi < 4; ++xi) {
            for (int zi = 0; zi < 4; ++zi) {
                int posX = pos.getX() + xi * 4 + 1 + 8 + random.nextInt(3);
                int posZ = pos.getZ() + zi * 4 + 1 + 8 + random.nextInt(3);
                BlockPos blockpos = world.getHeight(pos.add(posX, 0, posZ));
                blockpos = TreeHelper.findGround(world, blockpos).up();
                if (random.nextInt(6) != 0) continue;
                new WorldGenBigMushroom().func_76484_a(world.real(), random, blockpos.getX(), blockpos.getY(), blockpos.getZ());
            }
        }
    }

    public void makeWoolCircle(com.ferreusveritas.dynamictrees.api.backport.World world, Circle circle, int h, EnumGeneratorResult resultType) {
        this.makeWoolCircle(world, circle, h, resultType, 0);
    }

    public void makeWoolCircle(com.ferreusveritas.dynamictrees.api.backport.World world, Circle circle, int h, EnumGeneratorResult resultType, int flags) {
        for (int ix = -circle.radius; ix <= circle.radius; ++ix) {
            for (int iz = -circle.radius; iz <= circle.radius; ++iz) {
                if (!circle.isEdge(circle.x + ix, circle.z + iz)) continue;
                world.setBlockState(new BlockPos(circle.x + ix, h, circle.z + iz), new BlockState(Blocks.field_150325_L, (circle.x ^ circle.z) & 0xF), 0);
            }
        }
        if (resultType != EnumGeneratorResult.GENERATED) {
            BlockPos pos = new BlockPos(circle.x, h, circle.z);
            EnumDyeColor color = resultType.getColor();
            world.setBlockState(pos, new BlockState(Blocks.field_150325_L, color.getMetadata()));
            world.setBlockState(pos.up(), new BlockState(Blocks.field_150404_cg, color.getMetadata()));
        }
    }

    private EnumGeneratorResult makeTree(com.ferreusveritas.dynamictrees.api.backport.World world, Circle circle) {
        Species species;
        circle.add(8, 8);
        BlockPos pos = world.getHeight(new BlockPos(circle.x, 0, circle.z)).down();
        while (world.isAirBlock(pos) || TreeHelper.isTreePart(world, pos)) {
            pos = pos.down();
        }
        IBlockState blockState = world.getBlockState(pos);
        EnumGeneratorResult result = EnumGeneratorResult.GENERATED;
        Biome biome = world.getBiome(pos);
        IBiomeSpeciesSelector.Decision decision = this.biomeTreeHandler.getSpecies(world, biome, pos, blockState, this.random);
        result = decision.isHandled() ? ((species = decision.getSpecies()) != null ? (species.isAcceptableSoilForWorldgen(world, pos, blockState) ? (this.biomeTreeHandler.chance(biome, species, circle.radius, this.random) == IBiomeDensityProvider.EnumChance.OK ? (species.generate(world, pos, biome, this.random, circle.radius) ? EnumGeneratorResult.GENERATED : EnumGeneratorResult.FAILGENERATION) : EnumGeneratorResult.FAILCHANCE) : EnumGeneratorResult.FAILSOIL) : EnumGeneratorResult.NOTREE) : EnumGeneratorResult.UNHANDLEDBIOME;
        if (ModConfigs.worldGenDebug) {
            this.makeWoolCircle(world, circle, pos.getY(), result);
        }
        circle.add(-8, -8);
        return result;
    }

    public static enum EnumGeneratorResult {
        GENERATED(EnumDyeColor.WHITE),
        NOTREE(EnumDyeColor.BLACK),
        UNHANDLEDBIOME(EnumDyeColor.YELLOW),
        FAILSOIL(EnumDyeColor.BROWN),
        FAILCHANCE(EnumDyeColor.BLUE),
        FAILGENERATION(EnumDyeColor.RED);

        private final EnumDyeColor color;

        private EnumGeneratorResult(EnumDyeColor color) {
            this.color = color;
        }

        public EnumDyeColor getColor() {
            return this.color;
        }
    }
}

