/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.block;

import com.williambl.essentialfeatures.common.block.EFBlock;
import com.williambl.essentialfeatures.common.block.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.IFuelHandler;

public class BlockBlaze
extends EFBlock
implements IFuelHandler {
    public BlockBlaze(String registryName) {
        super(registryName, Material.field_151573_f, CreativeTabs.field_78030_b, SoundType.field_185852_e, 5.0f, 15.0f, 1.0f);
    }

    public int getBurnTime(ItemStack fuel) {
        if (fuel.func_77973_b() == Item.func_150898_a((Block)ModBlocks.BLAZE_BLOCK)) {
            return 4800;
        }
        return 0;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_70045_F() && entityIn instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entityIn))) {
            entityIn.func_70097_a(DamageSource.field_190095_e, 5.0f);
            entityIn.func_70015_d(10);
        }
        this.particleExplosion(worldIn, pos, worldIn.field_73012_v);
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 3; ++i) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        if (rand.nextDouble() < 0.01 || this.isTouchingWater(worldIn, pos)) {
            this.particleExplosion(worldIn, pos, rand);
        }
    }

    private boolean isTouchingWater(World worldIn, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (worldIn.func_180495_p(pos.func_177972_a(facing)).func_177230_c() != Blocks.field_150355_j) continue;
            return true;
        }
        return false;
    }

    private void particleExplosion(World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 5; ++i) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.LAVA, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
    }
}

