/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class BlockBlockBreaker
extends BlockDirectional {
    public static final PropertyBool TRIGGERED = PropertyBool.func_177716_a((String)"triggered");

    protected BlockBlockBreaker(String registryName, Material material, float hardness, float resistance) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.FALSE));
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.setRegistryName(registryName);
        this.func_149663_c(this.getRegistryName().toString());
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175640_z(pos) && state.func_177229_b((IProperty)TRIGGERED) == Boolean.valueOf(false)) {
                this.destroy(pos, state, worldIn);
                worldIn.func_180501_a(pos, state.func_177231_a((IProperty)TRIGGERED), 6);
            } else if (!worldIn.func_175640_z(pos) && (Boolean)state.func_177229_b((IProperty)TRIGGERED) == false == Boolean.FALSE) {
                worldIn.func_180501_a(pos, state.func_177231_a((IProperty)TRIGGERED), 6);
            }
        }
    }

    public void destroy(BlockPos pos, IBlockState state, World worldIn) {
        BlockPos offsetPos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N));
        Block offsetBlock = worldIn.func_180495_p(offsetPos).func_177230_c();
        worldIn.func_175655_b(offsetPos, true);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176387_N, (Comparable)BlockBlockBreaker.getFacingFromEntity(pos, placer)), 2);
    }

    public static EnumFacing getFacingFromEntity(BlockPos pos, EntityLivingBase entityIn) {
        if (MathHelper.func_76135_e((float)((float)entityIn.field_70165_t - (float)pos.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entityIn.field_70161_v - (float)pos.func_177952_p())) < 2.0f) {
            double d0 = entityIn.field_70163_u + (double)entityIn.func_70047_e();
            if (d0 - (double)pos.func_177956_o() > 2.0) {
                return EnumFacing.UP;
            }
            if ((double)pos.func_177956_o() - d0 > 0.0) {
                return EnumFacing.DOWN;
            }
        }
        return entityIn.func_174811_aO().func_176734_d();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N, TRIGGERED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)BlockBlockBreaker.getFacing(meta)).func_177226_a((IProperty)TRIGGERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)TRIGGERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Nullable
    public static EnumFacing getFacing(int meta) {
        int i = meta & 7;
        return i > 5 ? null : EnumFacing.func_82600_a((int)i);
    }
}

