/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.block;

import com.williambl.essentialfeatures.common.block.EFBlock;
import com.williambl.essentialfeatures.common.block.ModBlocks;
import com.williambl.essentialfeatures.common.tileentity.TileEntityRedstoneRod;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRedstoneRod
extends EFBlock
implements ITileEntityProvider {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    protected static final AxisAlignedBB END_ROD_VERTICAL_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    protected static final AxisAlignedBB END_ROD_NS_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);
    protected static final AxisAlignedBB END_ROD_EW_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);

    public BlockRedstoneRod(String registryName, Material material, CreativeTabs tab, SoundType soundType, float hardness, float resistance, float lightlevel) {
        super(registryName, material, tab, soundType, hardness, resistance, lightlevel);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
        this.field_149758_A = true;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityRedstoneRod();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)FACING, (Comparable)mirrorIn.func_185803_b((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k()) {
            default: {
                return END_ROD_EW_AABB;
            }
            case Z: {
                return END_ROD_NS_AABB;
            }
            case Y: 
        }
        return END_ROD_VERTICAL_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing enumfacing;
        IBlockState iblockstate = world.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
        if (iblockstate.func_177230_c() == ModBlocks.REDSTONE_ROD && (enumfacing = (EnumFacing)iblockstate.func_177229_b((IProperty)FACING)) == facing) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
        double d0 = (double)pos.func_177958_n() + 0.55 - (double)(rand.nextFloat() * 0.1f);
        double d1 = (double)pos.func_177956_o() + 0.55 - (double)(rand.nextFloat() * 0.1f);
        double d2 = (double)pos.func_177952_p() + 0.55 - (double)(rand.nextFloat() * 0.1f);
        double d3 = 0.4f - (rand.nextFloat() + rand.nextFloat()) * 0.4f;
        if (rand.nextInt(5) == 0) {
            worldIn.func_175688_a(EnumParticleTypes.END_ROD, d0 + (double)enumfacing.func_82601_c() * d3, d1 + (double)enumfacing.func_96559_d() * d3, d2 + (double)enumfacing.func_82599_e() * d3, rand.nextGaussian() * 0.005, rand.nextGaussian() * 0.005, rand.nextGaussian() * 0.005, new int[0]);
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWERED, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        if (meta > 5) {
            meta -= 6;
            iblockstate = iblockstate.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true));
        }
        iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            meta += 6;
        }
        return meta;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void activate(World worldIn, BlockPos pos, IBlockState blockstate) {
        worldIn.func_175656_a(pos, blockstate.func_177226_a((IProperty)POWERED, (Comparable)Boolean.TRUE));
    }

    public void deactivate(World worldIn, BlockPos pos, IBlockState blockstate) {
        worldIn.func_175656_a(pos, blockstate.func_177226_a((IProperty)POWERED, (Comparable)Boolean.FALSE));
    }

    public boolean isPowered(IBlockState blockstate) {
        return (Boolean)blockstate.func_177229_b((IProperty)POWERED);
    }

    public void redstoneEffects(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        double d0 = (double)pos.func_177958_n() + 0.55 - (double)(world.field_73012_v.nextFloat() * 0.1f);
        double d1 = (double)pos.func_177956_o() + 0.55 - (double)(world.field_73012_v.nextFloat() * 0.1f);
        double d2 = (double)pos.func_177952_p() + 0.55 - (double)(world.field_73012_v.nextFloat() * 0.1f);
        double d3 = 0.4f - (world.field_73012_v.nextFloat() + world.field_73012_v.nextFloat()) * 0.4f;
        for (int i = 0; i < world.field_73012_v.nextInt(10); ++i) {
            world.func_175688_a(EnumParticleTypes.REDSTONE, d0 + (double)enumfacing.func_82601_c() * d3, d1 + (double)enumfacing.func_96559_d() * d3, d2 + (double)enumfacing.func_82599_e() * d3, world.field_73012_v.nextGaussian() * 0.01, world.field_73012_v.nextGaussian() * 0.01, world.field_73012_v.nextGaussian() * 0.01, new int[0]);
            world.func_175688_a(EnumParticleTypes.END_ROD, d0 + (double)enumfacing.func_82601_c() * d3, d1 + (double)enumfacing.func_96559_d() * d3, d2 + (double)enumfacing.func_82599_e() * d3, world.field_73012_v.nextGaussian() * 0.005, world.field_73012_v.nextGaussian() * 0.005, world.field_73012_v.nextGaussian() * 0.005, new int[0]);
        }
    }
}

