/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.block;

import com.williambl.essentialfeatures.common.block.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class BlockStainedLamp
extends Block {
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    private final boolean isOn;
    static final String[] names = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};

    public BlockStainedLamp(String registryName, Material material, float hardness, float resistance, boolean isOn) {
        super(material);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.func_149711_c(hardness);
        this.func_149752_b(resistance);
        this.setRegistryName(registryName);
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)EnumDyeColor.WHITE));
        this.isOn = isOn;
        if (isOn) {
            this.func_149715_a(1.0f);
            this.func_149647_a(null);
        }
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        if (!this.isOn) {
            for (int x = 1; x < 16; ++x) {
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)x, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + names[x], "inventory"));
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176765_a();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumDyeColor enumdyecolor : EnumDyeColor.values()) {
            list.add((Object)new ItemStack((Block)this, 1, enumdyecolor.func_176765_a()));
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            if (this.isOn && !worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, ModBlocks.LIT_STAINED_LAMP.func_176223_P().func_177226_a(COLOR, state.func_177229_b(COLOR)), 2);
            } else if (!this.isOn && worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, ModBlocks.LIT_STAINED_LAMP.func_176223_P().func_177226_a(COLOR, state.func_177229_b(COLOR)), 2);
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (this.isOn && !worldIn.func_175640_z(pos)) {
                worldIn.func_175684_a(pos, (Block)this, 4);
            } else if (!this.isOn && worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, ModBlocks.LIT_STAINED_LAMP.func_176223_P().func_177226_a(COLOR, state.func_177229_b(COLOR)), 2);
            }
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && this.isOn && !worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, ModBlocks.STAINED_LAMP.func_176223_P().func_177226_a(COLOR, state.func_177229_b(COLOR)), 2);
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176765_a();
    }
}

