/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.block;

import com.google.common.collect.Lists;
import com.williambl.essentialfeatures.common.block.ModBlocks;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;

public class BlockStainedRedstoneTorch
extends BlockRedstoneTorch {
    static final String[] names = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    public final boolean field_150113_a;
    public int colour;
    private static final Map<World, List<Toggle>> toggles = new WeakHashMap<World, List<Toggle>>();

    public BlockStainedRedstoneTorch(String registryName, boolean isOn, int colour) {
        super(isOn);
        this.field_150113_a = isOn;
        this.colour = colour;
        this.setRegistryName(registryName);
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149647_a(CreativeTabs.field_78028_d);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.STAINED_REDSTONE_TORCHES[this.colour]);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        boolean flag = this.shouldBeOff(worldIn, pos, state);
        List<Toggle> list = toggles.get(worldIn);
        while (list != null && !list.isEmpty() && worldIn.func_82737_E() - list.get((int)0).time > 60L) {
            list.remove(0);
        }
        if (this.field_150113_a) {
            if (flag) {
                worldIn.func_180501_a(pos, ModBlocks.STAINED_REDSTONE_TORCHES[this.colour + 16].func_176223_P().func_177226_a((IProperty)field_176596_a, state.func_177229_b((IProperty)field_176596_a)), 3);
                if (this.isBurnedOut(worldIn, pos, true)) {
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                    for (int i = 0; i < 5; ++i) {
                        double d0 = (double)pos.func_177958_n() + rand.nextDouble() * 0.6 + 0.2;
                        double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.6 + 0.2;
                        double d2 = (double)pos.func_177952_p() + rand.nextDouble() * 0.6 + 0.2;
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                    }
                    worldIn.func_175684_a(pos, worldIn.func_180495_p(pos).func_177230_c(), 160);
                }
            }
        } else if (!flag && !this.isBurnedOut(worldIn, pos, false)) {
            worldIn.func_180501_a(pos, ModBlocks.STAINED_REDSTONE_TORCHES[this.colour].func_176223_P().func_177226_a((IProperty)field_176596_a, state.func_177229_b((IProperty)field_176596_a)), 3);
        }
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)ModBlocks.STAINED_REDSTONE_TORCHES[this.colour]));
    }

    private boolean shouldBeOff(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = ((EnumFacing)state.func_177229_b((IProperty)field_176596_a)).func_176734_d();
        return worldIn.func_175709_b(pos.func_177972_a(enumfacing), enumfacing);
    }

    private boolean isBurnedOut(World worldIn, BlockPos pos, boolean turnOff) {
        if (!toggles.containsKey(worldIn)) {
            toggles.put(worldIn, Lists.newArrayList());
        }
        List<Toggle> list = toggles.get(worldIn);
        if (turnOff) {
            list.add(new Toggle(pos, worldIn.func_82737_E()));
        }
        int i = 0;
        for (int j = 0; j < list.size(); ++j) {
            Toggle blockredstonetorch$toggle = list.get(j);
            if (!blockredstonetorch$toggle.pos.equals((Object)pos) || ++i < 8) continue;
            return true;
        }
        return false;
    }

    static class Toggle {
        BlockPos pos;
        long time;

        public Toggle(BlockPos pos, long time) {
            this.pos = pos;
            this.time = time;
        }
    }
}

