/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.block;

import com.williambl.essentialfeatures.common.block.BlockBlaze;
import com.williambl.essentialfeatures.common.block.BlockBlockBreaker;
import com.williambl.essentialfeatures.common.block.BlockBlockPlacer;
import com.williambl.essentialfeatures.common.block.BlockBrickVariant;
import com.williambl.essentialfeatures.common.block.BlockCryingObsidian;
import com.williambl.essentialfeatures.common.block.BlockDecorativeStone;
import com.williambl.essentialfeatures.common.block.BlockEFDoor;
import com.williambl.essentialfeatures.common.block.BlockFake;
import com.williambl.essentialfeatures.common.block.BlockNettles;
import com.williambl.essentialfeatures.common.block.BlockRedstoneRod;
import com.williambl.essentialfeatures.common.block.BlockSlate;
import com.williambl.essentialfeatures.common.block.BlockSpike;
import com.williambl.essentialfeatures.common.block.BlockStainedLamp;
import com.williambl.essentialfeatures.common.block.BlockStainedRedstoneTorch;
import com.williambl.essentialfeatures.common.block.BlockViewedBlock;
import com.williambl.essentialfeatures.common.block.EFBlock;
import com.williambl.essentialfeatures.common.config.ModConfig;
import com.williambl.essentialfeatures.common.item.ItemBlockDoor;
import com.williambl.essentialfeatures.common.item.ItemBlockWithSubtypes;
import com.williambl.essentialfeatures.common.item.ItemSlate;
import com.williambl.essentialfeatures.common.tileentity.TileEntityBlockPlacer;
import com.williambl.essentialfeatures.common.tileentity.TileEntityRedstoneRod;
import com.williambl.essentialfeatures.common.tileentity.TileEntityViewedBlock;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockStoneSlabNew;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    public static BlockViewedBlock VIEWED_BLOCK;
    public static EFBlock SMOOTH_GLOWSTONE;
    public static EFBlock POLISHED_GLOWSTONE;
    public static BlockStainedLamp STAINED_LAMP;
    public static BlockStainedLamp LIT_STAINED_LAMP;
    public static EFBlock SNOW_BRICK;
    public static BlockBlockBreaker BLOCK_BREAKER;
    public static BlockCryingObsidian CRYING_OBSIDIAN;
    public static BlockSpike SPIKE_BLOCK;
    public static BlockBlockPlacer BLOCK_PLACER;
    public static BlockDecorativeStone DECORATIVE_STONE;
    public static BlockBrickVariant BRICK_VARIANT;
    public static BlockFake SMOOTH_DOUBLE_STONE_SLAB;
    public static BlockFake SMOOTH_DOUBLE_SANDSTONE_SLAB;
    public static BlockFake SMOOTH_DOUBLE_RED_SANDSTONE_SLAB;
    public static BlockSlate SLATE;
    public static BlockBlaze BLAZE_BLOCK;
    public static EFBlock PACKED_SAND;
    public static EFBlock PACKED_RED_SAND;
    public static EFBlock PACKED_GRAVEL;
    public static BlockNettles NETTLES;
    public static BlockEFDoor NETHER_BRICK_DOOR;
    public static BlockEFDoor PURPUR_DOOR;
    public static BlockRedstoneRod REDSTONE_ROD;
    public static BlockStainedRedstoneTorch[] STAINED_REDSTONE_TORCHES;

    public static void addBlocks() {
        VIEWED_BLOCK = new BlockViewedBlock("viewed_block", Material.field_151576_e, 5.0f, 5.0f);
        SMOOTH_GLOWSTONE = new EFBlock("smooth_glowstone", Material.field_151592_s, CreativeTabs.field_78030_b, SoundType.field_185853_f, 0.5f, 2.0f, 1.0f);
        STAINED_LAMP = new BlockStainedLamp("stained_lamp", Material.field_151592_s, 0.3f, 1.5f, false);
        LIT_STAINED_LAMP = new BlockStainedLamp("lit_stained_lamp", Material.field_151592_s, 0.3f, 1.5f, true);
        POLISHED_GLOWSTONE = new EFBlock("polished_glowstone", Material.field_151592_s, CreativeTabs.field_78030_b, SoundType.field_185853_f, 1.0f, 2.0f, 1.0f);
        SNOW_BRICK = new EFBlock("snow_brick", Material.field_151596_z, CreativeTabs.field_78030_b, SoundType.field_185856_i, 0.5f, 1.0f);
        BLOCK_BREAKER = new BlockBlockBreaker("block_breaker", Material.field_76233_E, 3.0f, 3.0f);
        CRYING_OBSIDIAN = new BlockCryingObsidian("crying_obsidian", Material.field_151576_e, 100.0f, 100.0f);
        SPIKE_BLOCK = new BlockSpike("spike_block", Material.field_151573_f, 1.0f, 1.0f);
        BLOCK_PLACER = new BlockBlockPlacer("block_placer", Material.field_151576_e, 5.0f, 5.0f);
        DECORATIVE_STONE = new BlockDecorativeStone("decorative_stone", Material.field_151576_e, 3.0f, 3.0f);
        BRICK_VARIANT = new BlockBrickVariant("brick_variant", Material.field_151576_e, 3.0f, 3.0f);
        SMOOTH_DOUBLE_STONE_SLAB = new BlockFake("smooth_double_stone_slab", CreativeTabs.field_78030_b, Blocks.field_150334_T.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176555_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.STONE));
        SMOOTH_DOUBLE_SANDSTONE_SLAB = new BlockFake("smooth_double_sandstone_slab", CreativeTabs.field_78030_b, Blocks.field_150334_T.func_176223_P().func_177226_a((IProperty)BlockStoneSlab.field_176555_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockStoneSlab.field_176556_M, (Comparable)BlockStoneSlab.EnumType.SAND));
        SMOOTH_DOUBLE_RED_SANDSTONE_SLAB = new BlockFake("smooth_double_red_sandstone_slab", CreativeTabs.field_78030_b, Blocks.field_180388_cO.func_176223_P().func_177226_a((IProperty)BlockStoneSlabNew.field_176558_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockStoneSlabNew.field_176559_M, (Comparable)BlockStoneSlabNew.EnumType.RED_SANDSTONE));
        SLATE = new BlockSlate("slate", Material.field_151576_e, 2.0f, 3.0f);
        BLAZE_BLOCK = new BlockBlaze("blaze_block");
        PACKED_SAND = new EFBlock("packed_sand", Material.field_151595_p, CreativeTabs.field_78030_b, SoundType.field_185855_h, 0.5f, 1.0f);
        PACKED_RED_SAND = new EFBlock("packed_red_sand", Material.field_151595_p, CreativeTabs.field_78030_b, SoundType.field_185855_h, 0.5f, 1.0f);
        PACKED_GRAVEL = new EFBlock("packed_gravel", Material.field_151578_c, CreativeTabs.field_78030_b, SoundType.field_185849_b, 0.8f, 2.0f);
        NETTLES = new BlockNettles("stinging_nettles");
        NETHER_BRICK_DOOR = new BlockEFDoor("nether_brick_door", Material.field_151576_e, 1.0f, 1011, 1005);
        PURPUR_DOOR = new BlockEFDoor("purpur_door", Material.field_151576_e, 1.0f, 1011, 1005);
        REDSTONE_ROD = new BlockRedstoneRod("redstone_rod", Material.field_151594_q, CreativeTabs.field_78031_c, SoundType.field_185852_e, 0.5f, 0.0f, 0.95f);
        STAINED_REDSTONE_TORCHES = new BlockStainedRedstoneTorch[32];
        for (int i = 0; i < 16; ++i) {
            ModBlocks.STAINED_REDSTONE_TORCHES[i + 16] = new BlockStainedRedstoneTorch(BlockStainedRedstoneTorch.names[i] + "_stained_redstone_torch", false, i);
            ModBlocks.STAINED_REDSTONE_TORCHES[i] = new BlockStainedRedstoneTorch("lit_" + BlockStainedRedstoneTorch.names[i] + "_stained_redstone_torch", true, i);
        }
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        public static final Set<ItemBlock> ITEM_BLOCKS = new HashSet<ItemBlock>();

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            if (!ModConfig.blocks) {
                return;
            }
            IForgeRegistry registry = event.getRegistry();
            event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{VIEWED_BLOCK, SMOOTH_GLOWSTONE, STAINED_LAMP, LIT_STAINED_LAMP, POLISHED_GLOWSTONE, SNOW_BRICK, BLOCK_BREAKER, CRYING_OBSIDIAN, SPIKE_BLOCK, BLOCK_PLACER, DECORATIVE_STONE, BRICK_VARIANT, SMOOTH_DOUBLE_STONE_SLAB, SMOOTH_DOUBLE_SANDSTONE_SLAB, SMOOTH_DOUBLE_RED_SANDSTONE_SLAB, SLATE, BLAZE_BLOCK, PACKED_SAND, PACKED_RED_SAND, PACKED_GRAVEL, NETTLES, NETHER_BRICK_DOOR, PURPUR_DOOR, REDSTONE_ROD});
            event.getRegistry().registerAll((IForgeRegistryEntry[])STAINED_REDSTONE_TORCHES);
            GameRegistry.registerTileEntity(TileEntityViewedBlock.class, (String)VIEWED_BLOCK.getRegistryName().toString());
            GameRegistry.registerTileEntity(TileEntityBlockPlacer.class, (String)BLOCK_PLACER.getRegistryName().toString());
            GameRegistry.registerTileEntity(TileEntityRedstoneRod.class, (String)REDSTONE_ROD.getRegistryName().toString());
            GameRegistry.registerFuelHandler((IFuelHandler)BLAZE_BLOCK);
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            if (!ModConfig.blocks) {
                return;
            }
            ItemBlock[] items = new ItemBlock[]{new ItemBlock((Block)VIEWED_BLOCK), new ItemBlock((Block)SMOOTH_GLOWSTONE), new ItemBlockWithSubtypes(STAINED_LAMP, true, BlockStainedLamp.names), new ItemBlockWithSubtypes(LIT_STAINED_LAMP, true, BlockStainedLamp.names), new ItemBlock((Block)POLISHED_GLOWSTONE), new ItemBlock((Block)SNOW_BRICK), new ItemBlock((Block)BLOCK_BREAKER), new ItemBlock((Block)CRYING_OBSIDIAN), new ItemBlock((Block)SPIKE_BLOCK), new ItemBlock((Block)BLOCK_PLACER), new ItemBlockWithSubtypes(DECORATIVE_STONE, true, BlockDecorativeStone.names), new ItemBlockWithSubtypes(BRICK_VARIANT, true, BlockBrickVariant.names), new ItemBlock((Block)SMOOTH_DOUBLE_STONE_SLAB), new ItemBlock((Block)SMOOTH_DOUBLE_SANDSTONE_SLAB), new ItemBlock((Block)SMOOTH_DOUBLE_RED_SANDSTONE_SLAB), new ItemSlate(SLATE), new ItemBlock((Block)BLAZE_BLOCK), new ItemBlock((Block)PACKED_SAND), new ItemBlock((Block)PACKED_RED_SAND), new ItemBlock((Block)PACKED_GRAVEL), new ItemBlock((Block)NETTLES), new ItemBlockDoor((Block)NETHER_BRICK_DOOR), new ItemBlockDoor((Block)PURPUR_DOOR), new ItemBlock((Block)REDSTONE_ROD)};
            IForgeRegistry registry = event.getRegistry();
            for (ItemBlock itemBlock : items) {
                registry.register(itemBlock.setRegistryName(itemBlock.func_179223_d().getRegistryName()));
                ITEM_BLOCKS.add(itemBlock);
            }
            for (BlockStainedRedstoneTorch blockStainedRedstoneTorch : STAINED_REDSTONE_TORCHES) {
                if (!blockStainedRedstoneTorch.field_150113_a) continue;
                ItemBlock item = new ItemBlock((Block)blockStainedRedstoneTorch);
                registry.register(item.setRegistryName(blockStainedRedstoneTorch.getRegistryName()));
                ITEM_BLOCKS.add(item);
            }
        }

        @SubscribeEvent
        public static void registerItemBlockModels(ModelRegistryEvent event) {
            if (!ModConfig.blocks) {
                return;
            }
            VIEWED_BLOCK.initModel();
            SMOOTH_GLOWSTONE.initModel();
            STAINED_LAMP.initModel();
            LIT_STAINED_LAMP.initModel();
            POLISHED_GLOWSTONE.initModel();
            SNOW_BRICK.initModel();
            BLOCK_BREAKER.initModel();
            CRYING_OBSIDIAN.initModel();
            SPIKE_BLOCK.initModel();
            BLOCK_PLACER.initModel();
            DECORATIVE_STONE.initModel();
            BRICK_VARIANT.initModel();
            SMOOTH_DOUBLE_STONE_SLAB.initModel();
            SMOOTH_DOUBLE_SANDSTONE_SLAB.initModel();
            SMOOTH_DOUBLE_RED_SANDSTONE_SLAB.initModel();
            SLATE.initModel();
            BLAZE_BLOCK.initModel();
            PACKED_SAND.initModel();
            PACKED_RED_SAND.initModel();
            PACKED_GRAVEL.initModel();
            NETTLES.initModel();
            NETHER_BRICK_DOOR.initModel();
            PURPUR_DOOR.initModel();
            REDSTONE_ROD.initModel();
            for (BlockStainedRedstoneTorch torch : STAINED_REDSTONE_TORCHES) {
                torch.initModel();
            }
        }

        public static void registerTileEntities() {
            RegistrationHandler.registerTileEntity(TileEntityViewedBlock.class);
            RegistrationHandler.registerTileEntity(TileEntityBlockPlacer.class);
            RegistrationHandler.registerTileEntity(TileEntityRedstoneRod.class);
        }

        private static void registerTileEntity(Class<? extends TileEntity> tileEntityClass) {
            GameRegistry.registerTileEntity(tileEntityClass, (String)("essentialfeatures:" + tileEntityClass.getSimpleName().replaceFirst("TileEntity", "")));
        }

        @SideOnly(value=Side.CLIENT)
        public static void registerBlockColors() {
            BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
            blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> worldIn != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.func_77468_c(), new Block[]{NETTLES});
        }
    }
}

