/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.item;

import com.google.common.collect.Lists;
import com.williambl.essentialfeatures.common.item.EFItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemPortableNoteBlock
extends EFItem {
    private static final List<SoundEvent> INSTRUMENTS = Lists.newArrayList((Object[])new SoundEvent[]{SoundEvents.field_187682_dG, SoundEvents.field_187676_dE, SoundEvents.field_187688_dI, SoundEvents.field_187685_dH, SoundEvents.field_187679_dF, SoundEvents.field_193809_ey, SoundEvents.field_193807_ew, SoundEvents.field_193810_ez, SoundEvents.field_193808_ex, SoundEvents.field_193785_eE});

    public ItemPortableNoteBlock(String registryName) {
        super(registryName, CreativeTabs.field_78040_i);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        worldIn.func_184133_a((EntityPlayer)null, playerIn.func_180425_c(), this.getInstrumentFromBlock(worldIn, pos), SoundCategory.RECORDS, 3.0f, this.getPitchFromPosition(pos));
        worldIn.func_175688_a(EnumParticleTypes.NOTE, playerIn.field_70165_t, playerIn.field_70163_u + (double)playerIn.func_70047_e(), playerIn.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
        return EnumActionResult.SUCCESS;
    }

    private float getPitchFromPosition(BlockPos pos) {
        return (float)pos.func_177956_o() / 128.0f;
    }

    private SoundEvent getInstrumentFromBlock(World worldIn, BlockPos pos) {
        Block block;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Material material = iblockstate.func_185904_a();
        int i = 0;
        if (material == Material.field_151576_e) {
            i = 1;
        }
        if (material == Material.field_151595_p) {
            i = 2;
        }
        if (material == Material.field_151592_s) {
            i = 3;
        }
        if (material == Material.field_151575_d) {
            i = 4;
        }
        if ((block = iblockstate.func_177230_c()) == Blocks.field_150435_aG) {
            i = 5;
        }
        if (block == Blocks.field_150340_R) {
            i = 6;
        }
        if (block == Blocks.field_150325_L) {
            i = 7;
        }
        if (block == Blocks.field_150403_cj) {
            i = 8;
        }
        if (block == Blocks.field_189880_di) {
            i = 9;
        }
        return this.getInstrument(i);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        worldIn.func_184133_a((EntityPlayer)null, playerIn.func_180425_c(), this.getInstrument(0), SoundCategory.RECORDS, 3.0f, this.getPitchFromPosition(playerIn.func_180425_c()));
        worldIn.func_175688_a(EnumParticleTypes.NOTE, playerIn.field_70165_t, playerIn.field_70163_u + (double)playerIn.func_70047_e(), playerIn.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private SoundEvent getInstrument(int eventId) {
        if (eventId < 0 || eventId >= INSTRUMENTS.size()) {
            eventId = 0;
        }
        return INSTRUMENTS.get(eventId);
    }
}

