/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.item;

import com.williambl.essentialfeatures.client.music.ModSound;
import com.williambl.essentialfeatures.common.block.ModBlocks;
import com.williambl.essentialfeatures.common.config.ModConfig;
import com.williambl.essentialfeatures.common.item.EFItem;
import com.williambl.essentialfeatures.common.item.ItemCereal;
import com.williambl.essentialfeatures.common.item.ItemCookedNettles;
import com.williambl.essentialfeatures.common.item.ItemEFRecord;
import com.williambl.essentialfeatures.common.item.ItemPortableJukebox;
import com.williambl.essentialfeatures.common.item.ItemPortableNoteBlock;
import com.williambl.essentialfeatures.common.item.ItemRedstoneRodArrow;
import com.williambl.essentialfeatures.common.item.ItemRedstoneRodSword;
import com.williambl.essentialfeatures.common.item.ItemSharpenedArrow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemRecord;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModItems {
    public static ItemCereal CEREAL;
    public static ItemCereal IRON_CEREAL;
    public static EFItem DIRTY_CLAY;
    public static EFItem DIRTY_BRICK;
    public static EFItem SAND_CLAY_MIXTURE;
    public static EFItem CREAM_BRICK;
    public static ItemEFRecord RECORD_SCARLET;
    public static ItemEFRecord RECORD_LOFI;
    public static ItemPortableNoteBlock PORTABLE_NOTE_BLOCK;
    public static ItemSharpenedArrow SHARPENED_ARROW;
    public static ItemPortableJukebox PORTABLE_JUKEBOX;
    public static ArrayList<ItemPortableJukebox> PORTABLE_JUKEBOXES;
    public static ItemCookedNettles COOKED_NETTLES;
    public static ItemRedstoneRodSword REDSTONE_ROD_SWORD;
    public static ItemRedstoneRodArrow REDSTONE_ROD_ARROW;

    public static void addItems() {
        CEREAL = new ItemCereal("cereal", 1.0f, 6, false);
        IRON_CEREAL = new ItemCereal("iron_cereal", 3.0f, 6, true);
        DIRTY_CLAY = new EFItem("dirty_clay", CreativeTabs.field_78035_l);
        SAND_CLAY_MIXTURE = new EFItem("sand_clay_mixture", CreativeTabs.field_78035_l);
        DIRTY_BRICK = new EFItem("dirty_brick", CreativeTabs.field_78035_l);
        CREAM_BRICK = new EFItem("cream_brick", CreativeTabs.field_78035_l);
        RECORD_SCARLET = new ItemEFRecord("scarlet", ModSound.RECORD_SCARLET);
        RECORD_LOFI = new ItemEFRecord("lo-fi", ModSound.RECORD_LOFI);
        PORTABLE_NOTE_BLOCK = new ItemPortableNoteBlock("portable_note_block");
        SHARPENED_ARROW = new ItemSharpenedArrow("sharpened_arrow");
        COOKED_NETTLES = new ItemCookedNettles("cooked_nettles");
        REDSTONE_ROD_SWORD = new ItemRedstoneRodSword("redstone_rod_sword", Item.ToolMaterial.GOLD);
        REDSTONE_ROD_ARROW = new ItemRedstoneRodArrow("redstone_rod_arrow");
        ModItems.addPortableJukeboxes();
    }

    private static void addPortableJukeboxes() {
        PORTABLE_JUKEBOX = new ItemPortableJukebox("portable_jukebox", CreativeTabs.field_78040_i, null);
        HashMap<String, ItemRecord> discs = new HashMap<String, ItemRecord>();
        discs.put("13", (ItemRecord)Items.field_151096_cd);
        discs.put("cat", (ItemRecord)Items.field_151093_ce);
        discs.put("blocks", (ItemRecord)Items.field_151094_cf);
        discs.put("chirp", (ItemRecord)Items.field_151091_cg);
        discs.put("far", (ItemRecord)Items.field_151092_ch);
        discs.put("mall", (ItemRecord)Items.field_151089_ci);
        discs.put("mellohi", (ItemRecord)Items.field_151090_cj);
        discs.put("stal", (ItemRecord)Items.field_151087_ck);
        discs.put("strad", (ItemRecord)Items.field_151088_cl);
        discs.put("ward", (ItemRecord)Items.field_151085_cm);
        discs.put("11", (ItemRecord)Items.field_151086_cn);
        discs.put("wait", (ItemRecord)Items.field_151084_co);
        discs.put("scarlet", RECORD_SCARLET);
        discs.put("lo-fi", RECORD_LOFI);
        discs.forEach((name, record) -> PORTABLE_JUKEBOXES.add(new ItemPortableJukebox("portable_jukebox_" + name, CreativeTabs.field_78040_i, (ItemRecord)record)));
    }

    static {
        PORTABLE_JUKEBOXES = new ArrayList();
    }

    @Mod.EventBusSubscriber
    public static class RegistrationHandler {
        public static final Set<Item> ITEMS = new HashSet<Item>();

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            if (!ModConfig.items) {
                return;
            }
            Item[] items = new Item[]{CEREAL, IRON_CEREAL, DIRTY_CLAY, SAND_CLAY_MIXTURE, DIRTY_BRICK, CREAM_BRICK, RECORD_SCARLET, RECORD_LOFI, PORTABLE_JUKEBOX, PORTABLE_NOTE_BLOCK, SHARPENED_ARROW, COOKED_NETTLES, REDSTONE_ROD_SWORD, REDSTONE_ROD_ARROW};
            IForgeRegistry registry = event.getRegistry();
            for (Item item : items) {
                registry.register((IForgeRegistryEntry)item);
                ITEMS.add(item);
            }
            for (Item item : PORTABLE_JUKEBOXES) {
                registry.register((IForgeRegistryEntry)item);
                ITEMS.add(item);
            }
        }

        @SubscribeEvent
        public static void registerItemBlockModels(ModelRegistryEvent event) {
            if (!ModConfig.items) {
                return;
            }
            CEREAL.initModel();
            IRON_CEREAL.initModel();
            DIRTY_CLAY.initModel();
            SAND_CLAY_MIXTURE.initModel();
            DIRTY_BRICK.initModel();
            CREAM_BRICK.initModel();
            RECORD_SCARLET.initModel();
            RECORD_LOFI.initModel();
            PORTABLE_NOTE_BLOCK.initModel();
            SHARPENED_ARROW.initModel();
            COOKED_NETTLES.initModel();
            REDSTONE_ROD_SWORD.initModel();
            REDSTONE_ROD_ARROW.initModel();
            PORTABLE_JUKEBOX.initModel();
            PORTABLE_JUKEBOXES.forEach(EFItem::initModel);
        }

        @SideOnly(value=Side.CLIENT)
        public static void registerItemColors() {
            ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
            BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
            itemColors.func_186731_a((stack, tintIndex) -> {
                IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                return blockColors.func_186724_a(iblockstate, null, null, tintIndex);
            }, new Block[]{ModBlocks.NETTLES});
        }
    }
}

