/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.tileentity;

import com.williambl.essentialfeatures.common.block.BlockViewedBlock;
import com.williambl.essentialfeatures.common.config.ModConfig;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class TileEntityViewedBlock
extends TileEntity
implements ITickable {
    int radius = ModConfig.viewedRange;
    boolean wasLookingLastTime;
    int tickCounter = 0;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter != ModConfig.viewedDelay) {
            return;
        }
        this.tickCounter = 0;
        IBlockState blockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
        BlockViewedBlock block = (BlockViewedBlock)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
        this.wasLookingLastTime = block.isPowered(blockstate);
        BlockPos thisPos = this.func_174877_v();
        boolean isNowLooking = false;
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - this.radius), (double)(this.field_174879_c.func_177956_o() - this.radius), (double)(this.field_174879_c.func_177952_p() - this.radius), (double)(this.field_174879_c.func_177958_n() + this.radius), (double)(this.field_174879_c.func_177956_o() + this.radius), (double)(this.field_174879_c.func_177952_p() + this.radius)));
        for (EntityPlayer player : players) {
            if (isNowLooking) continue;
            isNowLooking = this.checkIfLooking(player, thisPos);
        }
        if (this.wasLookingLastTime != isNowLooking) {
            if (isNowLooking) {
                block.activate(this.field_145850_b, thisPos, blockstate);
            } else {
                block.deactivate(this.field_145850_b, thisPos, blockstate);
            }
        }
    }

    public boolean checkIfLooking(EntityPlayer player, BlockPos thisPos) {
        RayTraceResult rayPos = this.rayTrace(player, 50.0, 1.0f);
        BlockPos pos = rayPos.func_178782_a();
        return thisPos.equals((Object)pos);
    }

    public RayTraceResult rayTrace(EntityPlayer playerIn, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = this.getPositionEyes(playerIn, partialTicks);
        Vec3d vec3d1 = playerIn.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return this.field_145850_b.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public Vec3d getPositionEyes(EntityPlayer playerIn, float partialTicks) {
        if (partialTicks == 1.0f) {
            return new Vec3d(playerIn.field_70165_t, playerIn.field_70163_u + (double)playerIn.func_70047_e(), playerIn.field_70161_v);
        }
        double d0 = playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q) * (double)partialTicks;
        double d1 = playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) * (double)partialTicks + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s) * (double)partialTicks;
        return new Vec3d(d0, d1, d2);
    }
}

