/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.world;

import com.williambl.essentialfeatures.common.block.ModBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenBush;
import net.minecraftforge.fml.common.IWorldGenerator;

public class NettlesGen
implements IWorldGenerator {
    private WorldGenBush worldGenBush;
    private List<Biome> biomes = Arrays.asList(Biomes.field_76772_c, Biomes.field_185441_Q, Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_150583_P, Biomes.field_185448_Z, Biomes.field_185444_T, Biomes.field_185430_ab, Biomes.field_150585_R, Biomes.field_150582_Q, Biomes.field_185429_aa);

    public NettlesGen() {
        this.worldGenBush = new WorldGenBush((BlockBush)ModBlocks.NETTLES);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() == 0) {
            this.generatePlants(this.worldGenBush, world, random, chunkX, chunkZ, 40, 80, 2);
        }
    }

    private void generatePlants(WorldGenBush worldGen, World world, Random random, int chunkX, int chunkZ, int minY, int maxY, int chancesToSpawn) {
        int heightRange = maxY - minY;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int randY = random.nextInt(heightRange) + minY;
            BlockPos pos = new BlockPos(chunkX * 16 + 8, randY, chunkZ * 16 + 8);
            if (!this.biomes.contains(world.func_180494_b(pos))) continue;
            worldGen.func_180709_b(world, random, pos);
        }
    }
}

