/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockBreakerBlock
extends DirectionalBlock {
    public static final BooleanProperty TRIGGERED = BooleanProperty.func_177716_a((String)"triggered");

    protected BlockBreakerBlock(String registryName, Material material, float hardness, float resistance) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(hardness, resistance));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)field_176387_N, (Comparable)Direction.NORTH)).func_206870_a((IProperty)TRIGGERED, (Comparable)Boolean.FALSE));
        this.setRegistryName(registryName);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            if (worldIn.func_175640_z(pos)) {
                this.destroy(pos, state, worldIn);
                worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)TRIGGERED), 6);
            } else if (!worldIn.func_175640_z(pos)) {
                worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)TRIGGERED), 6);
            }
        }
    }

    public void destroy(BlockPos pos, BlockState state, World worldIn) {
        BlockPos offsetPos = pos.func_177972_a((Direction)state.func_177229_b((IProperty)field_176387_N));
        worldIn.func_175655_b(offsetPos, true);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)field_176387_N, (Comparable)BlockBreakerBlock.getFacingFromEntity(pos, placer)), 2);
    }

    public static Direction getFacingFromEntity(BlockPos pos, LivingEntity entityIn) {
        if (MathHelper.func_76135_e((float)((float)entityIn.field_70165_t - (float)pos.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entityIn.field_70161_v - (float)pos.func_177952_p())) < 2.0f) {
            double d0 = entityIn.field_70163_u + (double)entityIn.func_70047_e();
            if (d0 - (double)pos.func_177956_o() > 2.0) {
                return Direction.UP;
            }
            if ((double)pos.func_177956_o() - d0 > 0.0) {
                return Direction.DOWN;
            }
        }
        return entityIn.func_174811_aO().func_176734_d();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176387_N, TRIGGERED});
    }
}

