/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.item;

import com.google.common.collect.Lists;
import com.williambl.essentialfeatures.common.item.EFItem;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.properties.NoteBlockInstrument;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PortableNoteBlockItem
extends EFItem {
    private static final List<SoundEvent> INSTRUMENTS = Lists.newArrayList((Object[])new SoundEvent[]{SoundEvents.field_187682_dG, SoundEvents.field_187676_dE, SoundEvents.field_187688_dI, SoundEvents.field_187685_dH, SoundEvents.field_187679_dF, SoundEvents.field_193809_ey, SoundEvents.field_193807_ew, SoundEvents.field_193810_ez, SoundEvents.field_193808_ex, SoundEvents.field_193785_eE});

    public PortableNoteBlockItem(String registryName) {
        super(registryName, ItemGroup.field_78040_i);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        BlockPos pos = context.func_195995_a();
        world.func_184133_a(null, player.func_180425_c(), this.getInstrumentFromBlock(world, pos), SoundCategory.RECORDS, 3.0f, this.getPitchFromPosition(pos));
        world.func_195594_a((IParticleData)ParticleTypes.field_197597_H, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, 1.0, 0.0, 0.0);
        return ActionResultType.SUCCESS;
    }

    private float getPitchFromPosition(BlockPos pos) {
        return (float)pos.func_177956_o() / 128.0f;
    }

    private SoundEvent getInstrumentFromBlock(World worldIn, BlockPos pos) {
        return NoteBlockInstrument.func_208087_a((BlockState)worldIn.func_180495_p(pos)).func_208088_a();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        worldIn.func_184133_a(null, playerIn.func_180425_c(), this.getInstrument(0), SoundCategory.RECORDS, 3.0f, this.getPitchFromPosition(playerIn.func_180425_c()));
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197597_H, playerIn.field_70165_t, playerIn.field_70163_u + (double)playerIn.func_70047_e(), playerIn.field_70161_v, 1.0, 0.0, 0.0);
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    private SoundEvent getInstrument(int eventId) {
        if (eventId < 0 || eventId >= INSTRUMENTS.size()) {
            eventId = 0;
        }
        return INSTRUMENTS.get(eventId);
    }
}

