/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.networking;

import com.williambl.essentialfeatures.client.DistHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class PortableJukeboxMessage {
    private boolean startOrStop;
    private UUID playerUUID;
    private ResourceLocation disc;

    public PortableJukeboxMessage(boolean startOrStopIn, UUID entityUUIDIn, ResourceLocation discIn) {
        this.startOrStop = startOrStopIn;
        this.playerUUID = entityUUIDIn;
        this.disc = discIn;
    }

    PortableJukeboxMessage(PacketBuffer buf) {
        this(buf.readBoolean(), buf.func_179253_g(), buf.func_192575_l());
    }

    void encode(PacketBuffer buf) {
        buf.writeBoolean(this.startOrStop);
        buf.func_179252_a(this.playerUUID);
        buf.func_192572_a(this.disc);
    }

    void handle(Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isServer()) {
            return;
        }
        if (this.startOrStop) {
            ctx.get().enqueueWork(() -> DistHelper.playDiscToPlayer(this.playerUUID, this.disc));
        } else {
            ctx.get().enqueueWork(() -> DistHelper.stopDisc(this.disc));
        }
    }
}

