/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.tileentity;

import com.williambl.essentialfeatures.common.block.ViewedBlockBlock;
import com.williambl.essentialfeatures.common.config.Config;
import com.williambl.essentialfeatures.common.tileentity.ModTileEntities;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;

public class ViewedBlockTileEntity
extends TileEntity
implements ITickableTileEntity {
    int radius = Config.viewedBlockRange;
    boolean wasLookingLastTime;
    int tickCounter = 0;

    public ViewedBlockTileEntity() {
        super(ModTileEntities.VIEWED_BLOCK);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter != Config.viewedBlockDelay) {
            return;
        }
        this.tickCounter = 0;
        BlockState blockstate = this.field_145850_b.func_180495_p(this.func_174877_v());
        ViewedBlockBlock block = (ViewedBlockBlock)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
        this.wasLookingLastTime = block.isPowered(blockstate);
        BlockPos thisPos = this.func_174877_v();
        boolean isNowLooking = false;
        List players = this.field_145850_b.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - this.radius), (double)(this.field_174879_c.func_177956_o() - this.radius), (double)(this.field_174879_c.func_177952_p() - this.radius), (double)(this.field_174879_c.func_177958_n() + this.radius), (double)(this.field_174879_c.func_177956_o() + this.radius), (double)(this.field_174879_c.func_177952_p() + this.radius)));
        for (PlayerEntity player : players) {
            if (isNowLooking) continue;
            isNowLooking = this.checkIfLooking(player, thisPos);
        }
        if (this.wasLookingLastTime != isNowLooking) {
            if (isNowLooking) {
                block.activate(this.field_145850_b, thisPos, blockstate);
            } else {
                block.deactivate(this.field_145850_b, thisPos, blockstate);
            }
        }
    }

    public boolean checkIfLooking(PlayerEntity player, BlockPos thisPos) {
        BlockRayTraceResult rayResult = this.rayTrace(player, 50.0, 1.0f);
        return thisPos.equals((Object)rayResult.func_216350_a());
    }

    public BlockRayTraceResult rayTrace(PlayerEntity playerIn, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = this.getPositionEyes(playerIn, partialTicks);
        Vec3d vec3d1 = playerIn.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return this.field_145850_b.func_217299_a(new RayTraceContext(vec3d, vec3d2, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)playerIn));
    }

    public Vec3d getPositionEyes(PlayerEntity playerIn, float partialTicks) {
        if (partialTicks == 1.0f) {
            return new Vec3d(playerIn.field_70165_t, playerIn.field_70163_u + (double)playerIn.func_70047_e(), playerIn.field_70161_v);
        }
        double d0 = playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q) * (double)partialTicks;
        double d1 = playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) * (double)partialTicks + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s) * (double)partialTicks;
        return new Vec3d(d0, d1, d2);
    }
}

