/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.williambl.essentialfeatures.common.block.BlockBreakerBlock;
import com.williambl.essentialfeatures.common.block.BlockPlacerBlock;
import com.williambl.essentialfeatures.common.block.EFDoorBlock;
import com.williambl.essentialfeatures.common.block.ModBlocks;
import com.williambl.essentialfeatures.common.block.RedstoneRodBlock;
import com.williambl.essentialfeatures.common.block.SlateBlock;
import com.williambl.essentialfeatures.common.block.StainedLampBlock;
import com.williambl.essentialfeatures.common.block.StainedRedstoneTorchBlock;
import com.williambl.essentialfeatures.common.block.StainedRedstoneWallTorchBlock;
import com.williambl.essentialfeatures.common.block.ViewedBlockBlock;
import com.williambl.essentialfeatures.common.item.ModItems;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.RedstoneWallTorchBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new LootTables(event.getGenerator()));
        event.getGenerator().func_200390_a((IDataProvider)new BlockStates(event.getGenerator(), event.getExistingFileHelper()));
        event.getGenerator().func_200390_a((IDataProvider)new ItemModels(event.getGenerator(), event.getExistingFileHelper()));
    }

    public static class BlockStates
    extends BlockStateProvider {
        public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
            super(gen, "essentialfeatures", exFileHelper);
        }

        protected void registerStatesAndModels() {
            this.makeSimpleBlockState(ModBlocks.SMOOTH_GLOWSTONE, this.modLoc("block/smooth_glowstone"));
            this.makeSimpleBlockState(ModBlocks.POLISHED_GLOWSTONE, this.modLoc("block/polished_glowstone"));
            this.makeSimpleBlockState(ModBlocks.SNOW_BRICK, this.modLoc("block/snow_brick"));
            this.makeSimpleBlockState(ModBlocks.CRYING_OBSIDIAN, this.modLoc("block/crying_obsidian"));
            this.makeSimpleBlockState(ModBlocks.CARVED_STONE, this.modLoc("block/carved_stone"));
            this.makeSimpleBlockState(ModBlocks.CARVED_ANDESITE, this.modLoc("block/carved_andesite"));
            this.makeSimpleBlockState(ModBlocks.CARVED_DIORITE, this.modLoc("block/carved_diorite"));
            this.makeSimpleBlockState(ModBlocks.CARVED_GRANITE, this.modLoc("block/carved_granite"));
            this.makeSimpleBlockState(ModBlocks.CREAM_BRICKS, this.modLoc("block/cream_bricks"));
            this.makeSimpleBlockState(ModBlocks.DIRTY_BRICKS, this.modLoc("block/dirty_bricks"));
            this.makeSimpleBlockState(ModBlocks.LONG_BRICKS, this.modLoc("block/long_bricks"));
            this.makeSimpleBlockState(ModBlocks.BLUE_BRICKS, this.modLoc("block/blue_bricks"));
            this.makeSimpleBlockState(ModBlocks.MIXED_BRICKS, this.modLoc("block/mixed_bricks"));
            this.makeSimpleBlockState(ModBlocks.BLAZE_BLOCK, this.modLoc("block/blaze_block"));
            this.makeSimpleBlockState(ModBlocks.PACKED_SAND, this.modLoc("block/packed_sand"));
            this.makeSimpleBlockState(ModBlocks.PACKED_RED_SAND, this.modLoc("block/packed_red_sand"));
            this.makeSimpleBlockState(ModBlocks.PACKED_GRAVEL, this.modLoc("block/packed_gravel"));
            for (Pair pair : ModBlocks.STAINED_REDSTONE_TORCHES) {
                this.makeStandingTorchBlockState((StainedRedstoneTorchBlock)((Object)pair.getLeft()), this.modLoc("block/lit_" + ((StainedRedstoneTorchBlock)((Object)pair.getLeft())).getRegistryName().func_110623_a()), this.modLoc("block/" + ((StainedRedstoneTorchBlock)((Object)pair.getLeft())).getRegistryName().func_110623_a()));
                this.makeWallTorchBlockState((StainedRedstoneWallTorchBlock)((Object)pair.getRight()), this.modLoc("block/lit_" + ((StainedRedstoneTorchBlock)((Object)pair.getLeft())).getRegistryName().func_110623_a()), this.modLoc("block/" + ((StainedRedstoneTorchBlock)((Object)pair.getLeft())).getRegistryName().func_110623_a()));
            }
            for (StainedLampBlock stainedLampBlock : ModBlocks.STAINED_LAMPS) {
                this.makeLampBlockState(stainedLampBlock, this.modLoc("block/lit_" + stainedLampBlock.getRegistryName().func_110623_a()), this.modLoc("block/" + stainedLampBlock.getRegistryName().func_110623_a()));
            }
            this.makeBlockBreakerBlockState(ModBlocks.BLOCK_BREAKER, this.modLoc("block/block_breaker_inner"), this.modLoc("block/block_breaker_side"), this.mcLoc("block/piston_bottom"));
            this.makeBlockPlacerBlockState(ModBlocks.BLOCK_PLACER, this.modLoc("block/block_placer"), this.modLoc("block/block_placer_vertical"), this.mcLoc("block/furnace_side"), this.mcLoc("block/furnace_top"));
            this.makeDoorBlockState(ModBlocks.NETHER_BRICK_DOOR, this.modLoc("block/door_nether_brick_upper"), this.modLoc("block/door_nether_brick_lower"));
            this.makeDoorBlockState(ModBlocks.PURPUR_DOOR, this.modLoc("block/door_purpur_upper"), this.modLoc("block/door_purpur_lower"));
            this.makeRedstoneRodBlockState(ModBlocks.REDSTONE_ROD, this.modLoc("block/redstone_rod"));
            this.makeSlateBlockState(ModBlocks.SLATE, this.modLoc("block/slate_side"), this.modLoc("block/slate_top"));
            this.makeCrossModel(ModBlocks.SPIKE_BLOCK, this.modLoc("block/spike_block"));
            this.makeTintedCrossModel((Block)ModBlocks.NETTLES, this.modLoc("block/stinging_nettles"));
            this.makeViewedBlockModel(ModBlocks.VIEWED_BLOCK, this.modLoc("block/powered_viewed_block"), this.modLoc("block/viewed_block"));
        }

        private void makeSimpleBlockState(Block block, ResourceLocation texture) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/cube_all")))).texture("all", texture);
            this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStates.lambda$makeSimpleBlockState$0((ModelFile)model, arg_0));
        }

        private void makeLampBlockState(StainedLampBlock block, ResourceLocation onTexture, ResourceLocation offTexture) {
            ModelBuilder modelOn = ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a() + "_powered")).parent((ModelFile)this.getExistingFile(this.mcLoc("block/cube_all")))).texture("all", onTexture);
            ModelBuilder modelOff = ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/cube_all")))).texture("all", offTexture);
            this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStates.lambda$makeLampBlockState$1((ModelFile)modelOn, (ModelFile)modelOff, arg_0));
        }

        private void makeStandingTorchBlockState(StainedRedstoneTorchBlock block, ResourceLocation onTexture, ResourceLocation offTexture) {
            ModelBuilder modelStandingOn = ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a() + "_powered")).parent((ModelFile)this.getExistingFile(this.mcLoc("block/template_torch")))).texture("torch", onTexture);
            ModelBuilder modelStandingOff = ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/template_torch")))).texture("torch", offTexture);
            this.getVariantBuilder((Block)block).forAllStates(arg_0 -> BlockStates.lambda$makeStandingTorchBlockState$2((ModelFile)modelStandingOn, (ModelFile)modelStandingOff, arg_0));
        }

        private void makeWallTorchBlockState(StainedRedstoneWallTorchBlock block, ResourceLocation onTexture, ResourceLocation offTexture) {
            ModelBuilder modelWallOn = ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a() + "powered")).parent((ModelFile)this.getExistingFile(this.mcLoc("block/torch_wall")))).texture("torch", onTexture);
            ModelBuilder modelWallOff = ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/torch_wall")))).texture("torch", offTexture);
            this.getVariantBuilder((Block)block).forAllStates(arg_0 -> BlockStates.lambda$makeWallTorchBlockState$3((ModelFile)modelWallOn, (ModelFile)modelWallOff, arg_0));
        }

        private void makeBlockBreakerBlockState(BlockBreakerBlock block, ResourceLocation platformTexture, ResourceLocation sideTexture, ResourceLocation bottomTexture) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/template_piston")))).texture("platform", platformTexture)).texture("side", sideTexture)).texture("bottom", bottomTexture);
            this.getVariantBuilder((Block)block).forAllStates(arg_0 -> BlockStates.lambda$makeBlockBreakerBlockState$4((ModelFile)model, arg_0));
        }

        private void makeBlockPlacerBlockState(BlockPlacerBlock block, ResourceLocation frontTexture, ResourceLocation frontVerticalTexture, ResourceLocation sideTexture, ResourceLocation topTexture) {
            ModelBuilder horizontalModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/orientable")))).texture("front", frontTexture)).texture("side", sideTexture)).texture("top", topTexture);
            ModelBuilder verticalModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a() + "_vertical")).parent((ModelFile)this.getExistingFile(this.mcLoc("block/orientable_vertical")))).texture("front", frontVerticalTexture)).texture("side", topTexture);
            this.getVariantBuilder((Block)block).forAllStates(arg_0 -> BlockStates.lambda$makeBlockPlacerBlockState$5((ModelFile)horizontalModel, (ModelFile)verticalModel, arg_0));
        }

        private void makeDoorBlockState(EFDoorBlock block, ResourceLocation topTexture, ResourceLocation bottomTexture) {
            ModelBuilder bottomModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a() + "_bottom")).parent((ModelFile)this.getExistingFile(this.mcLoc("block/door_bottom")))).texture("top", topTexture)).texture("bottom", bottomTexture);
            ModelBuilder bottomHingeModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a() + "_bottom_rh")).parent((ModelFile)this.getExistingFile(this.mcLoc("block/door_bottom_rh")))).texture("top", topTexture)).texture("bottom", bottomTexture);
            ModelBuilder topModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a() + "_top")).parent((ModelFile)this.getExistingFile(this.mcLoc("block/door_top")))).texture("top", topTexture)).texture("bottom", bottomTexture);
            ModelBuilder topHingeModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a() + "_top_rh")).parent((ModelFile)this.getExistingFile(this.mcLoc("block/door_top_rh")))).texture("top", topTexture)).texture("bottom", bottomTexture);
            this.getVariantBuilder((Block)block).forAllStates(arg_0 -> BlockStates.lambda$makeDoorBlockState$6((ModelFile)bottomHingeModel, (ModelFile)bottomModel, (ModelFile)topHingeModel, (ModelFile)topModel, arg_0));
        }

        private void makeRedstoneRodBlockState(RedstoneRodBlock block, ResourceLocation texture) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/end_rod")))).texture("end_rod", texture)).texture("particle", texture);
            this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStates.lambda$makeRedstoneRodBlockState$7((ModelFile)model, arg_0));
        }

        private void makeSlateBlockState(SlateBlock block, ResourceLocation sideTexture, ResourceLocation topTexture) {
            ModelBuilder fullModel = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/cube_column")))).texture("side", sideTexture)).texture("end", topTexture);
            this.getVariantBuilder(block).forAllStates(arg_0 -> this.lambda$makeSlateBlockState$8((ModelFile)fullModel, arg_0));
        }

        private void makeCrossModel(Block block, ResourceLocation texture) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/cross")))).texture("cross", texture);
            this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStates.lambda$makeCrossModel$9((ModelFile)model, arg_0));
        }

        private void makeTintedCrossModel(Block block, ResourceLocation texture) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/tinted_cross")))).texture("cross", texture);
            this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStates.lambda$makeTintedCrossModel$10((ModelFile)model, arg_0));
        }

        private void makeViewedBlockModel(ViewedBlockBlock block, ResourceLocation onTexture, ResourceLocation offTexture) {
            ModelBuilder modelOn = ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a() + "_powered")).parent((ModelFile)this.getExistingFile(this.mcLoc("block/cube_all")))).texture("all", onTexture);
            ModelBuilder modelOff = ((BlockModelBuilder)((BlockModelBuilder)this.getBuilder(block.getRegistryName().func_110623_a())).parent((ModelFile)this.getExistingFile(this.mcLoc("block/cube_all")))).texture("all", offTexture);
            this.getVariantBuilder(block).forAllStates(arg_0 -> BlockStates.lambda$makeViewedBlockModel$11((ModelFile)modelOn, (ModelFile)modelOff, arg_0));
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeViewedBlockModel$11(ModelFile modelOn, ModelFile modelOff, BlockState state) {
            return (Boolean)state.func_177229_b((IProperty)ViewedBlockBlock.POWERED) != false ? ConfiguredModel.builder().modelFile(modelOn).build() : ConfiguredModel.builder().modelFile(modelOff).build();
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeTintedCrossModel$10(ModelFile model, BlockState state) {
            return ConfiguredModel.builder().modelFile(model).build();
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeCrossModel$9(ModelFile model, BlockState state) {
            return ConfiguredModel.builder().modelFile(model).build();
        }

        private /* synthetic */ ConfiguredModel[] lambda$makeSlateBlockState$8(ModelFile fullModel, BlockState state) {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            switch ((Integer)state.func_177229_b((IProperty)SlateBlock.LAYERS)) {
                case 1: {
                    builder.modelFile((ModelFile)this.getExistingFile(this.modLoc("block/slate_height2")));
                    break;
                }
                case 2: {
                    builder.modelFile((ModelFile)this.getExistingFile(this.modLoc("block/slate_height4")));
                    break;
                }
                case 3: {
                    builder.modelFile((ModelFile)this.getExistingFile(this.modLoc("block/slate_height6")));
                    break;
                }
                case 4: {
                    builder.modelFile((ModelFile)this.getExistingFile(this.modLoc("block/slate_height8")));
                    break;
                }
                case 5: {
                    builder.modelFile((ModelFile)this.getExistingFile(this.modLoc("block/slate_height10")));
                    break;
                }
                case 6: {
                    builder.modelFile((ModelFile)this.getExistingFile(this.modLoc("block/slate_height12")));
                    break;
                }
                case 7: {
                    builder.modelFile((ModelFile)this.getExistingFile(this.modLoc("block/slate_height14")));
                    break;
                }
                case 8: {
                    builder.modelFile(fullModel);
                }
            }
            return builder.build();
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeRedstoneRodBlockState$7(ModelFile model, BlockState state) {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            builder.modelFile(model);
            switch ((Direction)state.func_177229_b((IProperty)RedstoneRodBlock.FACING)) {
                case DOWN: {
                    builder.rotationX(180);
                    break;
                }
                case EAST: {
                    builder.rotationX(90);
                    builder.rotationY(90);
                    break;
                }
                case SOUTH: {
                    builder.rotationX(90);
                    builder.rotationY(180);
                    break;
                }
                case WEST: {
                    builder.rotationX(90);
                    builder.rotationY(270);
                    break;
                }
                case NORTH: {
                    builder.rotationX(90);
                }
            }
            return builder.build();
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeDoorBlockState$6(ModelFile bottomHingeModel, ModelFile bottomModel, ModelFile topHingeModel, ModelFile topModel, BlockState state) {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            if (state.func_177229_b((IProperty)EFDoorBlock.field_176521_M) == DoorHingeSide.LEFT) {
                if (state.func_177229_b((IProperty)EFDoorBlock.field_176523_O) == DoubleBlockHalf.LOWER) {
                    builder.modelFile((Boolean)state.func_177229_b((IProperty)EFDoorBlock.field_176519_b) != false ? bottomHingeModel : bottomModel);
                } else {
                    builder.modelFile((Boolean)state.func_177229_b((IProperty)EFDoorBlock.field_176519_b) != false ? topHingeModel : topModel);
                }
                switch ((Direction)state.func_177229_b((IProperty)EFDoorBlock.field_176520_a)) {
                    case EAST: {
                        builder.rotationY((Boolean)state.func_177229_b((IProperty)EFDoorBlock.field_176519_b) != false ? 90 : 0);
                        break;
                    }
                    case SOUTH: {
                        builder.rotationY((Boolean)state.func_177229_b((IProperty)EFDoorBlock.field_176519_b) != false ? 180 : 90);
                        break;
                    }
                    case WEST: {
                        builder.rotationY((Boolean)state.func_177229_b((IProperty)EFDoorBlock.field_176519_b) != false ? 270 : 180);
                        break;
                    }
                    case NORTH: {
                        builder.rotationY((Boolean)state.func_177229_b((IProperty)EFDoorBlock.field_176519_b) != false ? 0 : 270);
                    }
                }
            } else {
                if (state.func_177229_b((IProperty)EFDoorBlock.field_176523_O) == DoubleBlockHalf.LOWER) {
                    builder.modelFile((Boolean)state.func_177229_b((IProperty)EFDoorBlock.field_176519_b) != false ? bottomModel : bottomHingeModel);
                } else {
                    builder.modelFile((Boolean)state.func_177229_b((IProperty)EFDoorBlock.field_176519_b) != false ? topModel : topHingeModel);
                }
                switch ((Direction)state.func_177229_b((IProperty)EFDoorBlock.field_176520_a)) {
                    case EAST: {
                        builder.rotationY((Boolean)state.func_177229_b((IProperty)EFDoorBlock.field_176519_b) != false ? 270 : 0);
                        break;
                    }
                    case SOUTH: {
                        builder.rotationY((Boolean)state.func_177229_b((IProperty)EFDoorBlock.field_176519_b) != false ? 0 : 90);
                        break;
                    }
                    case WEST: {
                        builder.rotationY((Boolean)state.func_177229_b((IProperty)EFDoorBlock.field_176519_b) != false ? 90 : 180);
                        break;
                    }
                    case NORTH: {
                        builder.rotationY((Boolean)state.func_177229_b((IProperty)EFDoorBlock.field_176519_b) != false ? 180 : 270);
                    }
                }
            }
            return builder.build();
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeBlockPlacerBlockState$5(ModelFile horizontalModel, ModelFile verticalModel, BlockState state) {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            switch ((Direction)state.func_177229_b((IProperty)BlockBreakerBlock.field_176387_N)) {
                case WEST: {
                    builder.rotationY(270);
                    builder.modelFile(horizontalModel);
                    break;
                }
                case SOUTH: {
                    builder.rotationY(180);
                    builder.modelFile(horizontalModel);
                    break;
                }
                case EAST: {
                    builder.rotationY(90);
                    builder.modelFile(horizontalModel);
                    break;
                }
                case UP: {
                    builder.modelFile(verticalModel);
                    break;
                }
                case DOWN: {
                    builder.modelFile(verticalModel);
                    builder.rotationX(180);
                    break;
                }
                default: {
                    builder.modelFile(horizontalModel);
                }
            }
            return builder.build();
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeBlockBreakerBlockState$4(ModelFile model, BlockState state) {
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile(model);
            switch ((Direction)state.func_177229_b((IProperty)BlockBreakerBlock.field_176387_N)) {
                case WEST: {
                    builder.rotationY(270);
                    break;
                }
                case SOUTH: {
                    builder.rotationY(180);
                    break;
                }
                case EAST: {
                    builder.rotationY(90);
                    break;
                }
                case UP: {
                    builder.rotationX(90);
                    break;
                }
                case DOWN: {
                    builder.rotationX(270);
                }
            }
            return builder.build();
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeWallTorchBlockState$3(ModelFile modelWallOn, ModelFile modelWallOff, BlockState state) {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            if (((Boolean)state.func_177229_b((IProperty)RedstoneWallTorchBlock.field_196531_c)).booleanValue()) {
                builder.modelFile(modelWallOn);
            } else {
                builder.modelFile(modelWallOff);
            }
            switch ((Direction)state.func_177229_b((IProperty)StainedRedstoneWallTorchBlock.field_196530_b)) {
                case NORTH: {
                    builder.rotationY(270);
                    break;
                }
                case WEST: {
                    builder.rotationY(180);
                    break;
                }
                case SOUTH: {
                    builder.rotationY(90);
                }
            }
            return builder.build();
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeStandingTorchBlockState$2(ModelFile modelStandingOn, ModelFile modelStandingOff, BlockState state) {
            return (Boolean)state.func_177229_b((IProperty)RedstoneTorchBlock.field_196528_a) != false ? ConfiguredModel.builder().modelFile(modelStandingOn).build() : ConfiguredModel.builder().modelFile(modelStandingOff).build();
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeLampBlockState$1(ModelFile modelOn, ModelFile modelOff, BlockState state) {
            return (Boolean)state.func_177229_b((IProperty)StainedLampBlock.LIT) != false ? ConfiguredModel.builder().modelFile(modelOn).build() : ConfiguredModel.builder().modelFile(modelOff).build();
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeSimpleBlockState$0(ModelFile model, BlockState state) {
            return ConfiguredModel.builder().modelFile(model).build();
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "essentialfeatures", helper);
        }

        protected void registerModels() {
            this.makeItemModelFromBlock(ModBlocks.VIEWED_BLOCK);
            this.makeItemModelFromBlock(ModBlocks.SMOOTH_GLOWSTONE);
            this.makeItemModelFromBlock(ModBlocks.POLISHED_GLOWSTONE);
            this.makeItemModelFromBlock(ModBlocks.SNOW_BRICK);
            this.makeBlockBreakerItemModel(ModBlocks.BLOCK_BREAKER);
            this.makeItemModelFromBlock(ModBlocks.CRYING_OBSIDIAN);
            this.makeFlatItemModelFromBlock(ModBlocks.SPIKE_BLOCK);
            this.makeItemModelFromBlock((Block)ModBlocks.BLOCK_PLACER);
            this.makeItemModelFromBlock(ModBlocks.CARVED_STONE);
            this.makeItemModelFromBlock(ModBlocks.CARVED_ANDESITE);
            this.makeItemModelFromBlock(ModBlocks.CARVED_DIORITE);
            this.makeItemModelFromBlock(ModBlocks.CARVED_GRANITE);
            this.makeItemModelFromBlock(ModBlocks.CREAM_BRICKS);
            this.makeItemModelFromBlock(ModBlocks.DIRTY_BRICKS);
            this.makeItemModelFromBlock(ModBlocks.LONG_BRICKS);
            this.makeItemModelFromBlock(ModBlocks.BLUE_BRICKS);
            this.makeItemModelFromBlock(ModBlocks.MIXED_BRICKS);
            this.makeSlateItemModel(ModBlocks.SLATE);
            this.makeItemModelFromBlock(ModBlocks.BLAZE_BLOCK);
            this.makeItemModelFromBlock(ModBlocks.PACKED_SAND);
            this.makeItemModelFromBlock(ModBlocks.PACKED_RED_SAND);
            this.makeItemModelFromBlock(ModBlocks.PACKED_GRAVEL);
            this.makeFlatItemModelFromBlock((Block)ModBlocks.NETTLES);
            this.makeItemModelFromBlock(ModBlocks.REDSTONE_ROD);
            for (Pair pair : ModBlocks.STAINED_REDSTONE_TORCHES) {
                this.makeFlatItemModelFromTorchBlock((Block)pair.getLeft());
            }
            for (StainedLampBlock stainedLampBlock : ModBlocks.STAINED_LAMPS) {
                this.makeItemModelFromBlock(stainedLampBlock);
            }
            this.makeItemModelFromItem(ModItems.CEREAL);
            this.makeItemModelFromItem(ModItems.COOKED_NETTLES);
            this.makeItemModelFromItem(ModItems.CREAM_BRICK);
            this.makeItemModelFromItem(ModItems.DIRTY_BRICK);
            this.makeItemModelFromItem(ModItems.DIRTY_CLAY);
            this.makeItemModelFromItem(ModItems.IRON_CEREAL);
            this.makeItemModelFromItem(ModItems.PORTABLE_JUKEBOX);
            this.makeItemModelFromItem(ModItems.PORTABLE_NOTE_BLOCK);
            this.makeItemModelFromItem((Item)ModItems.RECORD_LOFI);
            this.makeItemModelFromItem((Item)ModItems.RECORD_SCARLET);
            this.makeItemModelFromItem((Item)ModItems.REDSTONE_ROD_ARROW);
            this.makeItemModelFromItem((Item)ModItems.REDSTONE_ROD_SWORD);
            this.makeItemModelFromItem(ModItems.SAND_CLAY_MIXTURE);
            this.makeItemModelFromItem((Item)ModItems.SHARPENED_ARROW);
        }

        private void makeItemModelFromBlock(Block block) {
            String path = block.getRegistryName().func_110623_a();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
        }

        private void makeFlatItemModelFromTorchBlock(Block block) {
            String path = block.getRegistryName().func_110623_a();
            this.makeItemModel(path, this.modLoc("block/lit_" + path));
        }

        private void makeFlatItemModelFromBlock(Block block) {
            String path = block.getRegistryName().func_110623_a();
            this.makeItemModel(path, this.modLoc("block/" + path));
        }

        private void makeItemModelFromItem(Item item) {
            String path = item.getRegistryName().func_110623_a();
            this.makeItemModel(path, this.modLoc("item/" + path));
        }

        private void makeItemModel(String path, ResourceLocation texture) {
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/generated")))).texture("layer0", texture);
        }

        private void makeBlockBreakerItemModel(BlockBreakerBlock block) {
            String path = block.getRegistryName().func_110623_a();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("block/cube_bottom_top")))).texture("bottom", this.mcLoc("block/piston_bottom"))).texture("side", this.modLoc("block/block_breaker_side"))).texture("top", this.modLoc("block/block_breaker_inner"));
        }

        private void makeSlateItemModel(SlateBlock block) {
            String path = block.getRegistryName().func_110623_a();
            ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/slate_height2")));
        }

        public String func_200397_b() {
            return "Essential Features Item Models";
        }
    }

    public static class LootTables
    extends BaseLootTables {
        public LootTables(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        @Override
        protected void addTables() {
            this.lootTables.put(ModBlocks.VIEWED_BLOCK, this.createStandardTable("viewed_block", ModBlocks.VIEWED_BLOCK));
            this.lootTables.put(ModBlocks.SMOOTH_GLOWSTONE, this.createStandardTable("smooth_glowstone", ModBlocks.SMOOTH_GLOWSTONE));
            this.lootTables.put(ModBlocks.POLISHED_GLOWSTONE, this.createStandardTable("polished_glowstone", ModBlocks.POLISHED_GLOWSTONE));
            this.lootTables.put(ModBlocks.SNOW_BRICK, this.createStandardTable("snow_brick", ModBlocks.SNOW_BRICK));
            this.lootTables.put(ModBlocks.BLOCK_BREAKER, this.createStandardTable("block_breaker", (Block)ModBlocks.BLOCK_BREAKER));
            this.lootTables.put(ModBlocks.CRYING_OBSIDIAN, this.createStandardTable("crying_obsidian", ModBlocks.CRYING_OBSIDIAN));
            this.lootTables.put(ModBlocks.SPIKE_BLOCK, this.createStandardTable("spike_block", ModBlocks.SPIKE_BLOCK));
            this.lootTables.put(ModBlocks.BLOCK_PLACER, this.createStandardTable("block_placer", (Block)ModBlocks.BLOCK_PLACER));
            this.lootTables.put(ModBlocks.CARVED_STONE, this.createStandardTable("carved_stone", ModBlocks.CARVED_STONE));
            this.lootTables.put(ModBlocks.CARVED_ANDESITE, this.createStandardTable("carved_andesite", ModBlocks.CARVED_ANDESITE));
            this.lootTables.put(ModBlocks.CARVED_DIORITE, this.createStandardTable("carved_diorite", ModBlocks.CARVED_DIORITE));
            this.lootTables.put(ModBlocks.CARVED_GRANITE, this.createStandardTable("carved_granite", ModBlocks.CARVED_GRANITE));
            this.lootTables.put(ModBlocks.CREAM_BRICKS, this.createStandardTable("cream_bricks", ModBlocks.CREAM_BRICKS));
            this.lootTables.put(ModBlocks.DIRTY_BRICKS, this.createStandardTable("dirty_bricks", ModBlocks.DIRTY_BRICKS));
            this.lootTables.put(ModBlocks.LONG_BRICKS, this.createStandardTable("long_bricks", ModBlocks.LONG_BRICKS));
            this.lootTables.put(ModBlocks.BLUE_BRICKS, this.createStandardTable("blue_bricks", ModBlocks.BLUE_BRICKS));
            this.lootTables.put(ModBlocks.MIXED_BRICKS, this.createStandardTable("mixed_bricks", ModBlocks.MIXED_BRICKS));
            this.lootTables.put(ModBlocks.BLAZE_BLOCK, this.createStandardTable("blaze_block", ModBlocks.BLAZE_BLOCK));
            this.lootTables.put(ModBlocks.PACKED_SAND, this.createStandardTable("packed_sand", ModBlocks.PACKED_SAND));
            this.lootTables.put(ModBlocks.PACKED_RED_SAND, this.createStandardTable("packed_red_sand", ModBlocks.PACKED_RED_SAND));
            this.lootTables.put(ModBlocks.PACKED_GRAVEL, this.createStandardTable("packed_gravel", ModBlocks.PACKED_GRAVEL));
            this.lootTables.put(ModBlocks.REDSTONE_ROD, this.createStandardTable("redstone_rod", ModBlocks.REDSTONE_ROD));
            for (Pair pair : ModBlocks.STAINED_REDSTONE_TORCHES) {
                this.lootTables.put(pair.getLeft(), this.createStandardTable(((StainedRedstoneTorchBlock)((Object)pair.getLeft())).getRegistryName().func_110623_a(), (Block)pair.getLeft()));
                this.lootTables.put(pair.getRight(), this.createStandardTable(((StainedRedstoneTorchBlock)((Object)pair.getLeft())).getRegistryName().func_110623_a(), (Block)pair.getLeft()));
            }
            for (StainedLampBlock stainedLampBlock : ModBlocks.STAINED_LAMPS) {
                this.lootTables.put(stainedLampBlock, this.createStandardTable(stainedLampBlock.getRegistryName().func_110623_a(), stainedLampBlock));
            }
        }
    }

    public static abstract class BaseLootTables
    extends LootTableProvider {
        private static final Logger LOGGER = LogManager.getLogger();
        private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
        private final DataGenerator generator;

        public BaseLootTables(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
            this.generator = dataGeneratorIn;
        }

        protected abstract void addTables();

        protected LootTable.Builder createStandardTable(String name, Block block) {
            LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block));
            return LootTable.func_216119_b().func_216040_a(builder);
        }

        public void func_200398_a(DirectoryCache cache) {
            this.addTables();
            HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
            for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
                tables.put(entry.getKey().func_220068_i(), entry.getValue().func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
            }
            this.writeTables(cache, tables);
        }

        private void writeTables(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
            Path outputFolder = this.generator.func_200391_b();
            System.out.println(outputFolder);
            tables.forEach((key, lootTable) -> {
                Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
                try {
                    IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
                }
                catch (IOException e) {
                    LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
                }
            });
        }

        public String func_200397_b() {
            return "EssentialFeatures Loot Tables";
        }
    }
}

