/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common;

import com.williambl.essentialfeatures.common.config.Config;
import com.williambl.essentialfeatures.common.item.ModItems;
import com.williambl.essentialfeatures.common.networking.ModPackets;
import com.williambl.essentialfeatures.common.networking.PortableJukeboxMessage;
import java.util.Objects;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class CommonEventHandler {
    @SubscribeEvent
    public void onPlayerDropItem(ItemTossEvent event) {
        ItemStack stack = event.getEntityItem().func_92059_d();
        if (stack.func_77973_b() == ModItems.PORTABLE_JUKEBOX) {
            PlayerEntity player = event.getPlayer();
            if (!player.field_70170_p.field_72995_K) {
                ModPackets.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new PortableJukeboxMessage(false, player.func_110124_au(), ItemStack.func_199557_a((CompoundNBT)stack.func_190925_c("Disc")).func_77973_b().getRegistryName()));
            }
        }
    }

    @SubscribeEvent
    public void OnPlayerOpenChest(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        Random rand = world.field_73012_v;
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof ChestTileEntity && world.func_204610_c(pos.func_177982_a(0, 1, 0)).func_206884_a(FluidTags.field_206959_a)) {
            for (int i = 0; i < world.field_73012_v.nextInt(50); ++i) {
                world.func_195594_a((IParticleData)ParticleTypes.field_203220_f, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)pos.func_177956_o() + 0.6, (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.5, 0.0);
            }
        }
    }

    @SubscribeEvent
    public void OnEntityDeath(LivingDeathEvent e) {
        Entity entity = e.getEntity();
        World world = entity.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        if (entity instanceof WitchEntity) {
            Random rand = world.field_73012_v;
            if (Config.witchBats) {
                for (int i = 0; i < 10; ++i) {
                    BatEntity bat = new BatEntity(EntityType.field_200791_e, world);
                    bat.func_70107_b(entity.func_226277_ct_() + rand.nextDouble() - 0.5, entity.func_226278_cu_() + rand.nextDouble(), entity.func_226281_cx_() + rand.nextDouble() - 0.5);
                    world.func_217376_c((Entity)bat);
                }
            }
            if (rand.nextDouble() < Config.witchCatChance && e.getSource().func_76355_l().equals("player")) {
                CatEntity cat = new CatEntity(EntityType.field_220360_g, world);
                cat.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
                cat.func_193101_c((PlayerEntity)Objects.requireNonNull(e.getSource().func_76346_g()));
                cat.func_70904_g(true);
                world.func_217376_c((Entity)cat);
            }
            world.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187920_gt, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
    }
}

