/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.block;

import com.williambl.essentialfeatures.common.block.EFBlock;
import com.williambl.essentialfeatures.common.block.ModBlocks;
import com.williambl.essentialfeatures.common.item.ModItems;
import com.williambl.essentialfeatures.common.tileentity.TileEntityRedstoneRod;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RedstoneRodBlock
extends EFBlock {
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");
    public static final DirectionProperty FACING = DirectionProperty.func_196962_a((String)"facing", (Direction[])Direction.values());
    protected static final VoxelShape END_ROD_VERTICAL_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape END_ROD_NS_AABB = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    protected static final VoxelShape END_ROD_EW_AABB = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);

    public RedstoneRodBlock(String registryName, Material material, SoundType soundType, float hardness, float resistance, int lightlevel) {
        super(registryName, material, soundType, hardness, resistance, lightlevel);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)POWERED, (Comparable)Boolean.FALSE)).func_206870_a((IProperty)FACING, (Comparable)Direction.UP));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityRedstoneRod();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)mirrorIn.func_185803_b((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext context) {
        switch (((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k()) {
            default: {
                return END_ROD_EW_AABB;
            }
            case Z: {
                return END_ROD_NS_AABB;
            }
            case Y: 
        }
        return END_ROD_VERTICAL_AABB;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction enumfacing;
        BlockState iblockstate = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d()));
        if (iblockstate.func_177230_c() == ModBlocks.REDSTONE_ROD && (enumfacing = (Direction)iblockstate.func_177229_b((IProperty)FACING)) == context.func_196000_l()) {
            return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l().func_176734_d());
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196000_l());
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        Direction enumfacing = (Direction)stateIn.func_177229_b((IProperty)FACING);
        double d0 = (double)pos.func_177958_n() + 0.55 - (double)(rand.nextFloat() * 0.1f);
        double d1 = (double)pos.func_177956_o() + 0.55 - (double)(rand.nextFloat() * 0.1f);
        double d2 = (double)pos.func_177952_p() + 0.55 - (double)(rand.nextFloat() * 0.1f);
        double d3 = 0.4f - (rand.nextFloat() + rand.nextFloat()) * 0.4f;
        if (rand.nextInt(5) == 0) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0 + (double)enumfacing.func_82601_c() * d3, d1 + (double)enumfacing.func_96559_d() * d3, d2 + (double)enumfacing.func_82599_e() * d3, rand.nextGaussian() * 0.005, rand.nextGaussian() * 0.005, rand.nextGaussian() * 0.005);
        }
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        super.func_196270_a(state, worldIn, pos, player);
        if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == ModItems.REDSTONE_ROD_SWORD && worldIn.func_175710_j(pos)) {
            ((TileEntityRedstoneRod)Objects.requireNonNull(worldIn.func_175625_s(pos))).makeLightning(state);
        }
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader reader, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWERED});
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public void activate(World worldIn, BlockPos pos, BlockState blockstate) {
        worldIn.func_175656_a(pos, (BlockState)blockstate.func_206870_a((IProperty)POWERED, (Comparable)Boolean.TRUE));
    }

    public void deactivate(World worldIn, BlockPos pos, BlockState blockstate) {
        worldIn.func_175656_a(pos, (BlockState)blockstate.func_206870_a((IProperty)POWERED, (Comparable)Boolean.FALSE));
    }

    public boolean isPowered(BlockState blockstate) {
        return (Boolean)blockstate.func_177229_b((IProperty)POWERED);
    }

    public void redstoneEffects(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Direction enumfacing = (Direction)state.func_177229_b((IProperty)FACING);
        double d0 = (double)pos.func_177958_n() + 0.55 - (double)(world.field_73012_v.nextFloat() * 0.1f);
        double d1 = (double)pos.func_177956_o() + 0.55 - (double)(world.field_73012_v.nextFloat() * 0.1f);
        double d2 = (double)pos.func_177952_p() + 0.55 - (double)(world.field_73012_v.nextFloat() * 0.1f);
        double d3 = 0.4f - (world.field_73012_v.nextFloat() + world.field_73012_v.nextFloat()) * 0.4f;
        for (int i = 0; i < world.field_73012_v.nextInt(10); ++i) {
            world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, d0 + (double)enumfacing.func_82601_c() * d3, d1 + (double)enumfacing.func_96559_d() * d3, d2 + (double)enumfacing.func_82599_e() * d3, world.field_73012_v.nextGaussian() * 0.01, world.field_73012_v.nextGaussian() * 0.01, world.field_73012_v.nextGaussian() * 0.01);
            world.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0 + (double)enumfacing.func_82601_c() * d3, d1 + (double)enumfacing.func_96559_d() * d3, d2 + (double)enumfacing.func_82599_e() * d3, world.field_73012_v.nextGaussian() * 0.005, world.field_73012_v.nextGaussian() * 0.005, world.field_73012_v.nextGaussian() * 0.005);
        }
    }
}

