/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class SlateBlock
extends Block
implements IWaterLoggable {
    public static final IntegerProperty LAYERS = IntegerProperty.func_177719_a((String)"layers", (int)1, (int)8);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{VoxelShapes.func_197880_a(), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public SlateBlock(String registryName, Material material, float hardness, float resistance) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(hardness, resistance));
        this.setRegistryName(registryName);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(1))).func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Integer)state.func_177229_b((IProperty)LAYERS) < 5;
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((IProperty)LAYERS)];
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((IProperty)LAYERS) - 1];
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        int i = (Integer)state.func_177229_b((IProperty)LAYERS);
        if (useContext.func_195996_i().func_77973_b() == this.func_199767_j() && i < 8) {
            if (useContext.func_196012_c()) {
                return useContext.func_196000_l() == Direction.UP;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState iblockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (iblockstate.func_177230_c() == this) {
            int i = (Integer)iblockstate.func_177229_b((IProperty)LAYERS);
            return (BlockState)iblockstate.func_206870_a((IProperty)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.func_196258_a(context);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{LAYERS, BlockStateProperties.field_208198_y});
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            }
            return true;
        }
        return false;
    }
}

