/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.block;

import com.google.common.collect.Lists;
import com.williambl.essentialfeatures.common.block.ModBlocks;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StainedRedstoneTorchBlock
extends RedstoneTorchBlock {
    static final String[] names = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "silver", "cyan", "purple", "blue", "brown", "green", "red", "black"};
    int colour;
    private static final Map<World, List<Toggle>> BURNED_TORCHES = new WeakHashMap<World, List<Toggle>>();

    public StainedRedstoneTorchBlock(String registryName, int colourIn) {
        super(Block.Properties.func_200945_a((Material)Material.field_151591_t));
        this.colour = colourIn;
        this.setRegistryName(registryName);
    }

    public int func_149750_m(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_196528_a) != false ? 7 : 0;
    }

    public Item getItemDropped(BlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)((Block)ModBlocks.STAINED_REDSTONE_TORCHES[this.colour].getLeft()));
    }

    public static void update(BlockState p_196527_0_, World p_196527_1_, BlockPos p_196527_2_, Random p_196527_3_, boolean p_196527_4_) {
        List<Toggle> list = BURNED_TORCHES.get(p_196527_1_);
        while (list != null && !list.isEmpty() && p_196527_1_.func_82737_E() - list.get((int)0).time > 60L) {
            list.remove(0);
        }
        if (((Boolean)p_196527_0_.func_177229_b((IProperty)field_196528_a)).booleanValue()) {
            if (p_196527_4_) {
                p_196527_1_.func_180501_a(p_196527_2_, (BlockState)p_196527_0_.func_206870_a((IProperty)field_196528_a, (Comparable)Boolean.FALSE), 3);
                if (StainedRedstoneTorchBlock.isBurnedOut(p_196527_1_, p_196527_2_, true)) {
                    p_196527_1_.func_184133_a(null, p_196527_2_, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.5f, 2.6f + (p_196527_1_.field_73012_v.nextFloat() - p_196527_1_.field_73012_v.nextFloat()) * 0.8f);
                    for (int i = 0; i < 5; ++i) {
                        double d0 = (double)p_196527_2_.func_177958_n() + p_196527_3_.nextDouble() * 0.6 + 0.2;
                        double d1 = (double)p_196527_2_.func_177956_o() + p_196527_3_.nextDouble() * 0.6 + 0.2;
                        double d2 = (double)p_196527_2_.func_177952_p() + p_196527_3_.nextDouble() * 0.6 + 0.2;
                        p_196527_1_.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                    p_196527_1_.func_205220_G_().func_205360_a(p_196527_2_, (Object)p_196527_1_.func_180495_p(p_196527_2_).func_177230_c(), 160);
                }
            }
        } else if (!p_196527_4_ && !StainedRedstoneTorchBlock.isBurnedOut(p_196527_1_, p_196527_2_, false)) {
            p_196527_1_.func_180501_a(p_196527_2_, (BlockState)p_196527_0_.func_206870_a((IProperty)field_196528_a, (Comparable)Boolean.TRUE), 3);
        }
    }

    protected boolean func_176597_g(World worldIn, BlockPos pos, BlockState state) {
        return worldIn.func_175709_b(pos.func_177977_b(), Direction.DOWN);
    }

    private static boolean isBurnedOut(World p_176598_0_, BlockPos worldIn, boolean pos) {
        List list = BURNED_TORCHES.computeIfAbsent(p_176598_0_, k -> Lists.newArrayList());
        if (pos) {
            list.add(new Toggle(worldIn.func_185334_h(), p_176598_0_.func_82737_E()));
        }
        int i = 0;
        for (int j = 0; j < list.size(); ++j) {
            Toggle blockredstonetorch$toggle = (Toggle)list.get(j);
            if (!blockredstonetorch$toggle.pos.equals((Object)worldIn) || ++i < 8) continue;
            return true;
        }
        return false;
    }

    static class Toggle {
        BlockPos pos;
        long time;

        public Toggle(BlockPos pos, long time) {
            this.pos = pos;
            this.time = time;
        }
    }
}

