/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class Config {
    public static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final CommonConfig COMMON_CONFIG;
    public static final ClientConfig CLIENT_CONFIG;
    public static boolean slate;
    public static boolean nettles;
    public static int viewedBlockDelay;
    public static int viewedBlockRange;
    public static boolean witchBats;
    public static double witchCatChance;
    public static boolean motd;
    public static boolean spawnExplosion;
    public static boolean customMusic;

    public static void refreshCommon() {
        slate = (Boolean)Config.COMMON_CONFIG.slate.get();
        nettles = (Boolean)Config.COMMON_CONFIG.nettles.get();
        viewedBlockDelay = (Integer)Config.COMMON_CONFIG.viewedBlockDelay.get();
        viewedBlockRange = (Integer)Config.COMMON_CONFIG.viewedBlockRange.get();
        witchBats = (Boolean)Config.COMMON_CONFIG.witchBats.get();
        witchCatChance = (Double)Config.COMMON_CONFIG.witchCatChance.get();
    }

    public static void refreshClient() {
        motd = (Boolean)Config.CLIENT_CONFIG.motd.get();
        spawnExplosion = (Boolean)Config.CLIENT_CONFIG.spawnExplosion.get();
        customMusic = (Boolean)Config.CLIENT_CONFIG.customMusic.get();
    }

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        spec.setConfig((CommentedConfig)configData);
    }

    static {
        slate = true;
        nettles = true;
        viewedBlockDelay = 2;
        viewedBlockRange = 50;
        witchBats = true;
        witchCatChance = 0.05;
        motd = true;
        spawnExplosion = true;
        customMusic = true;
        COMMON_CONFIG = new CommonConfig(COMMON_BUILDER);
        CLIENT_CONFIG = new ClientConfig(CLIENT_BUILDER);
        COMMON_SPEC = COMMON_BUILDER.build();
        CLIENT_SPEC = CLIENT_BUILDER.build();
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue motd;
        public final ForgeConfigSpec.BooleanValue spawnExplosion;
        public final ForgeConfigSpec.BooleanValue customMusic;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("misc");
            this.motd = builder.comment("Print the MOTD from the net in chat on login [default:true]").translation("config.motd").define("motd", true);
            this.spawnExplosion = builder.comment("Make explosion effects on respawn [default:true]").translation("config.spawn_explosion").define("spawn_explosion", true);
            this.customMusic = builder.comment("Play custom background music [default:true]").translation("config.custom_music").define("custom_music", true);
            builder.pop();
        }
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<Boolean> slate;
        public final ForgeConfigSpec.ConfigValue<Boolean> nettles;
        public final ForgeConfigSpec.ConfigValue<Integer> viewedBlockRange;
        public final ForgeConfigSpec.ConfigValue<Integer> viewedBlockDelay;
        public final ForgeConfigSpec.ConfigValue<Boolean> witchBats;
        public final ForgeConfigSpec.ConfigValue<Double> witchCatChance;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("generation");
            this.slate = builder.comment("Generate slate [default:true]").translation("config.slate.enable").define("slate", true);
            this.nettles = builder.comment("Generate nettles [default:true]").translation("config.nettles.enable").define("nettles", true);
            builder.pop();
            builder.push("optimisation");
            this.viewedBlockDelay = builder.comment("Ticks between viewed block checks [default:2]").translation("config.viewed_block.delay").defineInRange("viewed_block.delay", 2, 0, 20);
            this.viewedBlockRange = builder.comment("Range in which viewed block checks [default:50]").translation("config.viewed_block.range").defineInRange("viewed_block.range", 50, 0, 64);
            builder.pop();
            builder.push("misc");
            this.witchBats = builder.comment("Spawn a cloud of bats on witch death [default:true]").translation("config.witch.bats").define("witch.bats", true);
            this.witchCatChance = builder.comment("Chance that a cat will spawn on witch death [default:0.05]").translation("config.witch.cat_chance").defineInRange("witch.cat_chance", 0.05, 0.0, 1.0);
            builder.pop();
        }
    }
}

