/*
 * Decompiled with CFR 0.152.
 */
package com.williambl.essentialfeatures.common.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.williambl.essentialfeatures.common.item.crafting.LightningRecipe;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class LightningRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<LightningRecipe> {
    private final ILightningRecipeFactory factory;

    public LightningRecipeSerializer(ILightningRecipeFactory factory) {
        this.factory = factory;
    }

    public LightningRecipe read(@Nonnull ResourceLocation recipeName, @Nonnull JsonObject recipeJson) {
        ItemStack itemstack;
        String s = JSONUtils.func_151219_a((JsonObject)recipeJson, (String)"group", (String)"");
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)recipeJson, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)recipeJson, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)recipeJson, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
        if (!recipeJson.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (recipeJson.get("result").isJsonObject()) {
            itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)recipeJson, (String)"result"));
        } else {
            String s1 = JSONUtils.func_151200_h((JsonObject)recipeJson, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            if (!ForgeRegistries.ITEMS.containsKey(resourcelocation)) {
                throw new IllegalStateException("Item: " + s1 + " does not exist");
            }
            itemstack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(resourcelocation));
        }
        return this.factory.create(recipeName, s, ingredient, itemstack);
    }

    public LightningRecipe read(ResourceLocation recipeName, PacketBuffer recipeBuf) {
        String s = recipeBuf.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)recipeBuf);
        ItemStack itemstack = recipeBuf.func_150791_c();
        return this.factory.create(recipeName, s, ingredient, itemstack);
    }

    public void write(PacketBuffer recipeBuf, LightningRecipe recipe) {
        recipeBuf.func_180714_a(recipe.func_193358_e());
        ((Ingredient)recipe.func_192400_c().get(0)).func_199564_a(recipeBuf);
        recipeBuf.func_150788_a(recipe.func_77571_b());
        recipeBuf.writeFloat(recipe.func_222138_b());
    }

    static interface ILightningRecipeFactory {
        public LightningRecipe create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4);
    }
}

