/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.Birds;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pavocado.exoticbirds.entity.Birds.EntityBird;
import pavocado.exoticbirds.entity.EntityAILayEggInNest;
import pavocado.exoticbirds.init.ExoticbirdsItems;
import pavocado.exoticbirds.init.ExoticbirdsLootTables;
import pavocado.exoticbirds.init.ExoticbirdsSoundEvents;

public class EntityVulture
extends EntityBird {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_179556_br, Items.field_179558_bo, Items.field_179559_bp});

    public EntityVulture(World worldIn) {
        super(worldIn, ExoticbirdsItems.vulture_egg, 1, false, false);
        this.func_70105_a(1.1f, 1.5f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.setTemptedItemString("rabbit");
        this.setBreedItemString("rabbit");
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIMeleeAttack());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanic());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILayEggInNest(this, ExoticbirdsItems.vulture_egg));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByTarget());
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityRabbit.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new AIAttackPlayer());
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.85f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.4f, 0.6f);
    }

    protected SoundEvent func_184639_G() {
        return ExoticbirdsSoundEvents.ENTITY_VULTURE_AMBIENT;
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityVulture entityvulture = new EntityVulture(this.field_70170_p);
        entityvulture.setBirdType(this.getBirdType());
        return entityvulture;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ExoticbirdsLootTables.ENTITIES_VULTURE;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    class AIPanic
    extends EntityAIPanic {
        public AIPanic() {
            super((EntityCreature)EntityVulture.this, 2.0);
        }

        public boolean func_75250_a() {
            return !EntityVulture.this.func_70631_g_() && !EntityVulture.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class AIMeleeAttack
    extends EntityAIAttackMelee {
        public AIMeleeAttack() {
            super((EntityCreature)EntityVulture.this, 1.25, true);
        }

        protected void func_190102_a(EntityLivingBase entity, double distance) {
            double d0 = this.func_179512_a(entity);
            if (distance <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k((Entity)entity);
            } else if (distance <= d0 * 2.0) {
                if (this.field_75439_d <= 0) {
                    this.field_75439_d = 20;
                }
            } else {
                this.field_75439_d = 20;
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }

    class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget() {
            super((EntityCreature)EntityVulture.this, false, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (EntityVulture.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_179446_a(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            if (creatureIn instanceof EntityVulture && !creatureIn.func_70631_g_()) {
                super.func_179446_a(creatureIn, entityLivingBaseIn);
            }
        }
    }

    class AIAttackPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AIAttackPlayer() {
            super((EntityCreature)EntityVulture.this, EntityPlayer.class, 20, true, true, null);
        }

        public boolean func_75250_a() {
            if (EntityVulture.this.func_70631_g_()) {
                return false;
            }
            if (super.func_75250_a()) {
                for (EntityVulture entityvulture : EntityVulture.this.field_70170_p.func_72872_a(EntityVulture.class, EntityVulture.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                    if (!entityvulture.func_70631_g_()) continue;
                    return true;
                }
            }
            EntityVulture.this.func_70624_b(null);
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.5;
        }
    }
}

