/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.Birds;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pavocado.exoticbirds.entity.Birds.EntityBirdFlying;
import pavocado.exoticbirds.entity.EntityAILayEggInNest;
import pavocado.exoticbirds.init.ExoticbirdsItems;
import pavocado.exoticbirds.init.ExoticbirdsLootTables;
import pavocado.exoticbirds.init.ExoticbirdsSoundEvents;
import pavocado.exoticbirds.init.handlers.ConfigHandler;

public class EntityMagpie
extends EntityBirdFlying {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    public int scavengeTimer;

    public EntityMagpie(World worldIn) {
        super(worldIn, ExoticbirdsItems.magpie_egg, 1, false);
        this.func_70105_a(0.6f, 0.6f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.scavengeTimer = this.field_70146_Z.nextInt(6000) + 1000;
        this.setTemptedItemString("seeds");
        this.setBreedItemString("seeds");
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Items.field_151074_bl, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILayEggInNest(this, ExoticbirdsItems.magpie_egg));
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.75f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(7.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return ExoticbirdsSoundEvents.ENTITY_MAGPIE_AMBIENT;
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_() && this.scavengeTimer-- <= 0) {
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack.func_190926_b()) {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, this.getScavengedItem());
            } else {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
            }
            this.scavengeTimer = this.field_70146_Z.nextInt(6000) + 1000;
        }
        super.func_70636_d();
    }

    private ItemStack getScavengedItem() {
        ItemStack stack = ItemStack.field_190927_a;
        switch (this.field_70146_Z.nextInt(5)) {
            case 0: {
                stack = new ItemStack(Items.field_151121_aF);
                break;
            }
            case 1: {
                stack = new ItemStack(Items.field_151007_F);
                break;
            }
            case 2: {
                stack = new ItemStack(Items.field_151055_y);
                break;
            }
            case 3: {
                stack = new ItemStack(Items.field_151145_ak);
                break;
            }
            case 4: {
                stack = new ItemStack(Items.field_151042_j);
            }
        }
        return stack;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!super.func_184645_a(player, hand)) {
            ItemStack magpiestack = this.func_184614_ca();
            ItemStack playerstack = player.func_184586_b(hand);
            if (!this.field_70170_p.field_72995_K && !magpiestack.func_190926_b() && playerstack.func_77973_b() == Items.field_151074_bl) {
                if (ConfigHandler.magpie_scavenge) {
                    this.func_70099_a(magpiestack, 0.0f);
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                    this.scavengeTimer = this.field_70146_Z.nextInt(6000) + 1000;
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        ItemStack itemstack = this.func_184614_ca();
        if (!this.field_70170_p.field_72995_K && !itemstack.func_190926_b() && ConfigHandler.magpie_scavenge) {
            this.func_70099_a(itemstack, 0.0f);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
            this.scavengeTimer = this.field_70146_Z.nextInt(6000) + 6000;
        }
        return super.func_70097_a(source, amount);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityMagpie entitymagpie = new EntityMagpie(this.field_70170_p);
        entitymagpie.setBirdType(this.getBirdType());
        return entitymagpie;
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("ScavengeTime", this.scavengeTimer);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.scavengeTimer = tagCompund.func_74762_e("ScavengeTime");
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ExoticbirdsLootTables.ENTITIES_MAGPIE;
    }
}

