/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.Birds;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import pavocado.exoticbirds.entity.Birds.EntityBird;
import pavocado.exoticbirds.entity.EntityAILayEggInNest;
import pavocado.exoticbirds.init.ExoticbirdsItems;
import pavocado.exoticbirds.init.ExoticbirdsLootTables;
import pavocado.exoticbirds.init.ExoticbirdsSoundEvents;

public class EntityPeafowl
extends EntityBird {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb, Items.field_185163_cU});
    private static final DataParameter<Boolean> TRAIN_OPEN = EntityDataManager.func_187226_a(EntityPeafowl.class, (DataSerializer)DataSerializers.field_187198_h);
    private int trainTimer;

    public EntityPeafowl(World worldIn) {
        super(worldIn, ExoticbirdsItems.peafowl_egg, 3, true, true);
        this.func_70105_a(1.0f, 1.2f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.trainTimer = this.field_70146_Z.nextInt(2000) + 1500;
        this.setTemptedItemString("seeds");
        this.setBreedItemString("seeds");
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILayEggInNest(this, ExoticbirdsItems.peafowl_egg));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TRAIN_OPEN, (Object)false);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 0.6f);
    }

    protected SoundEvent func_184639_G() {
        return ExoticbirdsSoundEvents.ENTITY_PEAFOWL_AMBIENT;
    }

    protected SoundEvent func_184601_bQ() {
        return ExoticbirdsSoundEvents.ENTITY_PEAFOWL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ExoticbirdsSoundEvents.ENTITY_PEAFOWL_HURT;
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.contains(stack.func_77973_b()) && this.getBirdType() != 2;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityPeafowl entitypeafowl = new EntityPeafowl(this.field_70170_p);
        entitypeafowl.setBirdType(this.getBirdType());
        return entitypeafowl;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof EntityPeafowl)) {
            return false;
        }
        EntityPeafowl entitypeafowl = (EntityPeafowl)otherAnimal;
        if (entitypeafowl.getBirdType() == 0 && this.getBirdType() == 1 || entitypeafowl.getBirdType() == 1 && this.getBirdType() == 0) {
            return this.func_70880_s() && entitypeafowl.func_70880_s();
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.trainTimer >= 0) {
                --this.trainTimer;
            }
            if (!this.getTrain() && (this.func_70880_s() && this.getBirdType() == 0 || this.field_70170_p.func_72890_a((Entity)this, 3.0) != null && this.getBirdType() == 2)) {
                this.setTrain(true);
                this.func_184185_a(SoundEvents.field_187867_gJ, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                this.trainTimer = 500 + this.field_70146_Z.nextInt(100);
            }
            if (this.trainTimer < 0 && this.getTrain()) {
                this.setTrain(false);
                this.func_184185_a(SoundEvents.field_187867_gJ, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    public boolean getTrain() {
        return (Boolean)this.field_70180_af.func_187225_a(TRAIN_OPEN);
    }

    public void setTrain(boolean setStand) {
        this.field_70180_af.func_187227_b(TRAIN_OPEN, (Object)setStand);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Train", this.getTrain());
        tagCompound.func_74768_a("StandTime", this.trainTimer);
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setTrain(tagCompund.func_74767_n("Train"));
        this.trainTimer = tagCompund.func_74762_e("StandTime");
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(80) == 0) {
                this.setBirdType(2);
            } else {
                this.setBirdType(this.field_70146_Z.nextInt(this.noOfTypes - 1));
            }
        }
        return livingdata;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        this.trainTimer = this.field_70146_Z.nextInt(2000) + 2500;
        return super.func_70097_a(source, amount);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.getBirdType() == 0) {
            return ExoticbirdsLootTables.ENTITIES_PEACOCK;
        }
        return ExoticbirdsLootTables.ENTITIES_PEAHEN;
    }
}

