/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.network;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatBase;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.JsonSerializableSet;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import pavocado.exoticbirds.entity.Birds.EntityBird;
import pavocado.exoticbirds.init.EnumBirdTypes;
import pavocado.exoticbirds.init.ExoticbirdsAchievements;
import pavocado.exoticbirds.network.MessageBase;
import pavocado.exoticbirds.network.MessagePlaySoundBook;
import pavocado.exoticbirds.network.NetworkHandler;

public class MessageLogBird
extends MessageBase<MessageLogBird> {
    private int birdEntity;

    public MessageLogBird() {
    }

    public MessageLogBird(Entity entity) {
        this.birdEntity = entity.func_145782_y();
    }

    public void fromBytes(ByteBuf buf) {
        this.birdEntity = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.birdEntity);
    }

    @Override
    public void handleClientSide(MessageLogBird message, EntityPlayerSP player) {
    }

    @Override
    public void handleServerSide(MessageLogBird message, EntityPlayerMP player) {
        this.updateBirdsLogged(player.field_70170_p.func_73045_a(message.birdEntity), player);
    }

    protected void updateBirdsLogged(Entity birdEnt, EntityPlayerMP player) {
        if (birdEnt instanceof EntityBird) {
            String birdStr = EntityList.func_75621_b((Entity)birdEnt);
            JsonSerializableSet jsonserializableset = (JsonSerializableSet)player.func_147099_x().func_150870_b((StatBase)ExoticbirdsAchievements.achievementLogAllSpecies);
            if (jsonserializableset == null) {
                jsonserializableset = (JsonSerializableSet)player.func_147099_x().func_150872_a((StatBase)ExoticbirdsAchievements.achievementLogAllSpecies, (IJsonSerializable)new JsonSerializableSet());
            }
            if (birdEnt instanceof EntityBird) {
                if (jsonserializableset.contains((Object)birdStr)) {
                    player.func_146105_b(new TextComponentTranslation("book.alreadylogged.line", new Object[]{new TextComponentTranslation("entity." + birdStr + ".name", new Object[0])}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)), false);
                    player.func_146105_b(new TextComponentTranslation("book.species.line", new Object[]{new TextComponentTranslation(((EntityBird)birdEnt).getBirdSpeciesNameUnformatted(), new Object[0])}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)), false);
                    NetworkHandler.sendTo(new MessagePlaySoundBook(true), player);
                } else {
                    player.func_146105_b(new TextComponentTranslation("book.log.line", new Object[]{new TextComponentTranslation("entity." + birdStr + ".name", new Object[0])}).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)), false);
                    player.func_146105_b(new TextComponentTranslation("book.species.line", new Object[]{new TextComponentTranslation(((EntityBird)birdEnt).getBirdSpeciesNameUnformatted(), new Object[0])}).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)), false);
                    NetworkHandler.sendTo(new MessagePlaySoundBook(false), player);
                }
                jsonserializableset.add((Object)birdStr);
            }
            if (player.func_147099_x().func_77442_b(ExoticbirdsAchievements.achievementLogAllSpecies) && jsonserializableset.size() >= EnumBirdTypes.values().length) {
                HashSet hashset = Sets.newHashSet();
                for (int i = 0; i < EnumBirdTypes.values().length; ++i) {
                    hashset.add(EntityList.func_75621_b((Entity)EnumBirdTypes.byMetadata(i).getEntity(player.field_70170_p)));
                }
                for (String s1 : jsonserializableset) {
                    Iterator iterator1 = hashset.iterator();
                    while (iterator1.hasNext()) {
                        String biomegenbase1 = (String)iterator1.next();
                        if (!biomegenbase1.equals(s1)) continue;
                        iterator1.remove();
                    }
                    if (!hashset.isEmpty()) continue;
                    break;
                }
                if (hashset.isEmpty()) {
                    player.func_71029_a((StatBase)ExoticbirdsAchievements.achievementLogAllSpecies);
                }
            }
        }
    }
}

