/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.render;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import pavocado.exoticbirds.entity.Birds.EntityFlamingo;
import pavocado.exoticbirds.models.ModelFlamingo;

public class RenderFlamingo
extends RenderLiving<EntityFlamingo> {
    private static final ResourceLocation birdTexture1 = new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_andean.png");
    private static final ResourceLocation birdTexture2 = new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_caribbean.png");
    private static final ResourceLocation birdTexture3 = new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_chilean.png");
    private static final ResourceLocation birdTexture4 = new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_greater.png");
    private static final ResourceLocation birdTexture5 = new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_james.png");
    private static final ResourceLocation birdTexture6 = new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_lesser.png");
    private static final ResourceLocation birdTexture7 = new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_greater_black.png");

    public RenderFlamingo(RenderManager manager) {
        super(manager, (ModelBase)new ModelFlamingo(), 0.3f);
    }

    protected float handleRotationFloat(EntityFlamingo livingBase, float partialTicks) {
        float f1 = livingBase.wingRotation + (livingBase.startRotation - livingBase.wingRotation) * partialTicks;
        float f2 = livingBase.groundOffset + (livingBase.destPos - livingBase.groundOffset) * partialTicks;
        return (MathHelper.func_76126_a((float)f1) + 1.0f) * f2;
    }

    protected ResourceLocation getEntityTexture(EntityFlamingo entity) {
        switch (entity.getBirdType()) {
            case 0: {
                return birdTexture1;
            }
            case 1: {
                return birdTexture2;
            }
            case 2: {
                return birdTexture3;
            }
            case 3: {
                return birdTexture4;
            }
            case 4: {
                return birdTexture5;
            }
            case 5: {
                return birdTexture6;
            }
            case 6: {
                return birdTexture7;
            }
        }
        return birdTexture1;
    }
}

