/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.Birds;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pavocado.exoticbirds.entity.AI.EntityAILayEggInNest;
import pavocado.exoticbirds.entity.Birds.EntityBird;
import pavocado.exoticbirds.init.EnumBirdTypes;
import pavocado.exoticbirds.init.ExoticbirdsLootTables;
import pavocado.exoticbirds.init.ExoticbirdsSoundEvents;

public class EntityCassowary
extends EntityBird {
    private int angerLevel;
    private UUID angerTargetUUID;

    public EntityCassowary(World worldIn) {
        super(worldIn, EnumBirdTypes.CASSOWARY.getBirdEgg(), EnumBirdTypes.CASSOWARY.getNumberOfTypes(), false, EnumBirdTypes.CASSOWARY.isGendered());
        this.func_70105_a(0.9f, 1.9f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILayEggInNest(this, EnumBirdTypes.CASSOWARY.getBirdEgg()));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Items.field_151034_e, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByAggressor(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AITargetAggressor(this));
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(EnumBirdTypes.CASSOWARY.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 0.6f);
    }

    protected SoundEvent func_184639_G() {
        return ExoticbirdsSoundEvents.ENTITY_CASSOWARY_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ExoticbirdsSoundEvents.ENTITY_CASSOWARY_AMBIENT;
    }

    protected SoundEvent func_184615_bR() {
        return ExoticbirdsSoundEvents.ENTITY_CASSOWARY_AMBIENT;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151034_e;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74777_a("Anger", (short)this.angerLevel);
        if (this.angerTargetUUID != null) {
            compound.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.angerLevel = compound.func_74765_d("Anger");
        String s = compound.func_74779_i("HurtBy");
        if (!s.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(s);
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            this.func_70604_c((EntityLivingBase)entityplayer);
            if (entityplayer != null) {
                this.field_70717_bb = entityplayer;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer) {
            this.becomeAngryAt(entity);
        }
        return super.func_70097_a(source, amount);
    }

    private void becomeAngryAt(Entity p_70835_1_) {
        this.angerLevel = 400 + this.field_70146_Z.nextInt(400);
        if (p_70835_1_ instanceof EntityLivingBase) {
            this.func_70604_c((EntityLivingBase)p_70835_1_);
        }
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityCassowary entitycassowary = new EntityCassowary(this.field_70170_p);
        entitycassowary.setBirdType(this.getBirdType());
        return entitycassowary;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ExoticbirdsLootTables.ENTITIES_CASSOWARY;
    }

    public void func_70604_c(@Nullable EntityLivingBase livingBase) {
        super.func_70604_c(livingBase);
        if (livingBase != null) {
            this.angerTargetUUID = livingBase.func_110124_au();
        }
    }

    protected void func_70619_bc() {
        IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
        if (this.isAngry()) {
            --this.angerLevel;
        }
        if (this.angerLevel > 0 && this.angerTargetUUID != null && this.func_70643_av() == null) {
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            this.func_70604_c((EntityLivingBase)entityplayer);
            this.field_70717_bb = entityplayer;
            this.field_70718_bc = this.func_142015_aE();
        }
        super.func_70619_bc();
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    static class AITargetAggressor
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AITargetAggressor(EntityCassowary cassowary) {
            super((EntityCreature)cassowary, EntityPlayer.class, true);
        }

        public boolean func_75250_a() {
            return ((EntityCassowary)this.field_75299_d).isAngry() && super.func_75250_a();
        }
    }

    static class AIHurtByAggressor
    extends EntityAIHurtByTarget {
        public AIHurtByAggressor(EntityCassowary cassowary) {
            super((EntityCreature)cassowary, true, new Class[0]);
        }

        protected void func_179446_a(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            super.func_179446_a(creatureIn, entityLivingBaseIn);
            if (creatureIn instanceof EntityCassowary) {
                ((EntityCassowary)creatureIn).becomeAngryAt((Entity)entityLivingBaseIn);
            }
        }
    }
}

