/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.Birds;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import pavocado.exoticbirds.entity.AI.EntityAIBirdFollowOwner;
import pavocado.exoticbirds.entity.AI.EntityAIBirdSit;
import pavocado.exoticbirds.entity.AI.EntityAIBirdSwim;
import pavocado.exoticbirds.entity.AI.EntityAILayEggInNest;
import pavocado.exoticbirds.entity.Birds.EntityBirdTameable;
import pavocado.exoticbirds.gui.container.ContainerPelicanChest;
import pavocado.exoticbirds.init.EnumBirdTypes;
import pavocado.exoticbirds.init.ExoticbirdsLootTables;
import pavocado.exoticbirds.network.MessageOpenPelicanInventory;
import pavocado.exoticbirds.network.NetworkHandler;

public class EntityPelican
extends EntityBirdTameable
implements IInventoryChangedListener {
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151115_aP, Items.field_179566_aV});
    private static final DataParameter<Integer> RING_COLOR = EntityDataManager.func_187226_a(EntityPelican.class, (DataSerializer)DataSerializers.field_187192_b);
    public ContainerPelicanChest pelicanChest;
    private int timeUntilFish;
    private IItemHandler itemHandler = null;

    public EntityPelican(World worldIn) {
        super(worldIn, EnumBirdTypes.PELICAN.getBirdEgg(), EnumBirdTypes.PELICAN.getNumberOfTypes(), true, EnumBirdTypes.PELICAN.isGendered());
        this.func_70105_a(0.6f, 1.15f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.initPelicanChest();
        this.timeUntilFish = this.field_70146_Z.nextInt(5000) + 4000;
    }

    protected void func_184651_r() {
        this.aiSit = new EntityAIBirdSit(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBirdSwim((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILayEggInNest(this, EnumBirdTypes.PELICAN.getBirdEgg()));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIBirdFollowOwner(this, 1.0, 10.0f, 5.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 0.9));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RING_COLOR, (Object)EnumDyeColor.RED.func_176767_b());
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.9f;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.isTamed() && this.timeUntilFish-- < 0) {
            this.fishUpItem();
            this.timeUntilFish = this.field_70146_Z.nextInt(5000) + 4000;
        }
        super.func_70636_d();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(EnumBirdTypes.PELICAN.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 0.6f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151115_aP;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.isTamed()) {
            if (!itemstack.func_190926_b()) {
                EnumDyeColor enumdyecolor;
                if (itemstack.func_77973_b() instanceof ItemFood) {
                    ItemFood itemfood = (ItemFood)itemstack.func_77973_b();
                    if (TEMPTATION_ITEMS.contains(itemstack.func_77973_b())) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                        this.func_70691_i(itemfood.func_150905_g(itemstack));
                        return true;
                    }
                } else if (itemstack.func_77973_b() == Items.field_151100_aR && (enumdyecolor = EnumDyeColor.func_176766_a((int)itemstack.func_77960_j())) != this.getRingColor()) {
                    this.setRingColor(enumdyecolor);
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    return true;
                }
            }
            if (this.isOwner((EntityLivingBase)player) && !this.func_70877_b(itemstack)) {
                if (!this.func_70631_g_() && this.isTamed() && player.func_70093_af()) {
                    this.openGUI(player);
                    return true;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.aiSit.setSitting(!this.isSitting());
                    this.field_70703_bu = false;
                    this.field_70699_by.func_75499_g();
                }
            }
        } else if (itemstack.func_77973_b() == Items.field_179566_aV) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.setTamedBy(player);
                    this.field_70699_by.func_75499_g();
                    this.aiSit.setSitting(true);
                    this.func_70606_j(18.0f);
                    this.playTameEffect(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.playTameEffect(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityPelican entitypelican = new EntityPelican(this.field_70170_p);
        entitypelican.setBirdType(this.getBirdType());
        if (this.isTamed()) {
            entitypelican.setOwnerId(this.func_184753_b());
            entitypelican.setTamed(true);
        }
        return entitypelican;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!(otherAnimal instanceof EntityPelican)) {
            return false;
        }
        if (!this.isTamed()) {
            return false;
        }
        EntityPelican entitypelican = (EntityPelican)otherAnimal;
        if (entitypelican.getBirdType() == this.getBirdType()) {
            return this.func_70880_s() && entitypelican.func_70880_s();
        }
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ExoticbirdsLootTables.ENTITIES_PELICAN;
    }

    protected void initPelicanChest() {
        ContainerPelicanChest containerpelicanchest = this.pelicanChest;
        this.pelicanChest = new ContainerPelicanChest("PelicanChest", 5);
        this.pelicanChest.func_110133_a(this.func_70005_c_());
        if (containerpelicanchest != null) {
            containerpelicanchest.func_110132_b(this);
            int i = Math.min(containerpelicanchest.func_70302_i_(), this.pelicanChest.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = containerpelicanchest.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.pelicanChest.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.pelicanChest.func_110134_a(this);
        this.itemHandler = new InvWrapper((IInventory)this.pelicanChest);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("FishTime", this.timeUntilFish);
        if (this.isTamed()) {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.pelicanChest.func_70302_i_(); ++i) {
                ItemStack itemstack = this.pelicanChest.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.timeUntilFish = compound.func_74762_e("FishTime");
        if (this.isTamed()) {
            NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
            this.initPelicanChest();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                if (j < 0 || j >= this.pelicanChest.func_70302_i_()) continue;
                this.pelicanChest.func_70299_a(j, new ItemStack(nbttagcompound));
            }
        }
    }

    public EnumDyeColor getRingColor() {
        return EnumDyeColor.func_176766_a((int)((Integer)this.field_70180_af.func_187225_a(RING_COLOR) & 0xF));
    }

    public void setRingColor(EnumDyeColor ringColor) {
        this.field_70180_af.func_187227_b(RING_COLOR, (Object)ringColor.func_176767_b());
    }

    public void func_76316_a(IInventory invBasic) {
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (this.field_70170_p.field_72995_K) {
            this.pelicanChest.func_110133_a(this.func_70005_c_());
            NetworkHandler.sendToServer(new MessageOpenPelicanInventory((Entity)this));
        }
    }

    public void fishUpItem() {
        if (!this.field_70170_p.field_72995_K && this.pelicanChest != null && !this.func_70631_g_()) {
            ItemStack fishStack = new ItemStack(Items.field_151115_aP, 1, this.field_70146_Z.nextInt(3));
            boolean storedFish = false;
            for (int i = 0; i < this.pelicanChest.func_70302_i_(); ++i) {
                if (this.pelicanChest.func_70301_a(i).func_190926_b()) {
                    this.pelicanChest.func_70299_a(i, fishStack);
                    storedFish = true;
                    break;
                }
                if (!this.pelicanChest.func_70301_a(i).func_77969_a(fishStack) || this.pelicanChest.func_70301_a(i).func_190916_E() >= this.pelicanChest.func_70301_a(i).func_77976_d()) continue;
                this.pelicanChest.func_70301_a(i).func_190917_f(1);
                storedFish = true;
                break;
            }
            if (!storedFish) {
                this.func_70099_a(fishStack, 1.0f);
            }
            this.func_184185_a(SoundEvents.field_187808_ef, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.pelicanChest != null) {
            for (int i = 0; i < this.pelicanChest.func_70302_i_(); ++i) {
                ItemStack itemstack = this.pelicanChest.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }
}

