/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.Birds.Phoenix;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import pavocado.exoticbirds.entity.Birds.EntityBird;
import pavocado.exoticbirds.entity.Birds.Phoenix.EntityCloudPhoenix;
import pavocado.exoticbirds.entity.Birds.Phoenix.EntityDesertPhoenix;
import pavocado.exoticbirds.entity.Birds.Phoenix.EntityEnderPhoenix;
import pavocado.exoticbirds.entity.Birds.Phoenix.EntityFirePhoenix;
import pavocado.exoticbirds.entity.Birds.Phoenix.EntityNetherPhoenix;
import pavocado.exoticbirds.entity.Birds.Phoenix.EntitySnowPhoenix;
import pavocado.exoticbirds.entity.Birds.Phoenix.EntityTwilightPhoenix;
import pavocado.exoticbirds.entity.Birds.Phoenix.EntityWaterPhoenix;
import pavocado.exoticbirds.init.EnumBirdTypes;
import pavocado.exoticbirds.init.ExoticbirdsBlocks;
import pavocado.exoticbirds.init.ExoticbirdsLootTables;
import pavocado.exoticbirds.init.ExoticbirdsSoundEvents;
import pavocado.exoticbirds.init.handlers.ConfigHandler;

public abstract class EntityPhoenix
extends EntityBird {
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(EntityPhoenix.class, (DataSerializer)DataSerializers.field_187198_h);
    private int wingFlapCount = 0;

    public EntityPhoenix(World worldIn, ItemStack egg, int types, boolean canFloat, boolean gender) {
        super(worldIn, egg, types, canFloat, gender);
        this.func_70105_a(1.5f, 1.5f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70178_ae = true;
    }

    public EntityPhoenix(World worldIn) {
        super(worldIn, new ItemStack(ExoticbirdsBlocks.phoenix_egg), EnumBirdTypes.FIRE_PHOENIX.getNumberOfTypes(), true, EnumBirdTypes.FIRE_PHOENIX.isGendered());
        this.func_70105_a(1.5f, 1.5f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.9f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(EnumBirdTypes.FIRE_PHOENIX.getMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
    }

    @Override
    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 0.9f);
    }

    protected SoundEvent func_184639_G() {
        return ExoticbirdsSoundEvents.ENTITY_PHOENIX_AMBIENT;
    }

    public void replaceWithNewPhoenix() {
        if (!this.field_70170_p.field_72995_K && this.getBirdType() > 0 && this.getBirdType() < 8) {
            EntityPhoenix entityphoenix;
            switch (this.getBirdType()) {
                case 1: {
                    entityphoenix = new EntityCloudPhoenix(this.field_70170_p);
                    break;
                }
                case 2: {
                    entityphoenix = new EntityWaterPhoenix(this.field_70170_p);
                    break;
                }
                case 3: {
                    entityphoenix = new EntityNetherPhoenix(this.field_70170_p);
                    break;
                }
                case 4: {
                    entityphoenix = new EntitySnowPhoenix(this.field_70170_p);
                    break;
                }
                case 5: {
                    entityphoenix = new EntityDesertPhoenix(this.field_70170_p);
                    break;
                }
                case 6: {
                    entityphoenix = new EntityEnderPhoenix(this.field_70170_p);
                    break;
                }
                case 7: {
                    entityphoenix = new EntityTwilightPhoenix(this.field_70170_p);
                    break;
                }
                default: {
                    entityphoenix = new EntityFirePhoenix(this.field_70170_p);
                }
            }
            entityphoenix.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            entityphoenix.setSaddled(this.getSaddled());
            entityphoenix.func_70606_j(this.func_110143_aJ());
            if (entityphoenix.func_145818_k_()) {
                entityphoenix.func_96094_a(this.func_95999_t());
            }
            this.field_70170_p.func_72838_d((Entity)entityphoenix);
            this.func_70106_y();
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.spawnAmbientParticles();
            if (this.field_70146_Z.nextInt(24) == 0) {
                this.func_184185_a(ExoticbirdsSoundEvents.ENTITY_PHOENIX_FIRE, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            if (this.wingFlapCount % 14 == 0) {
                this.func_184185_a(ExoticbirdsSoundEvents.ENTITY_PHOENIX_FLAP, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
        }
        ++this.wingFlapCount;
    }

    public abstract void spawnAmbientParticles();

    public boolean getSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setSaddled(boolean setStand) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)setStand);
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74757_a("Saddled", this.getSaddled());
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setSaddled(tagCompund.func_74767_n("Saddled"));
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        boolean isHolding;
        ItemStack itemstack = player.func_184586_b(hand);
        boolean bl = isHolding = !itemstack.func_190926_b();
        if (isHolding && itemstack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (!this.func_70631_g_() && this.func_184207_aI()) {
            return super.func_184645_a(player, hand);
        }
        if (isHolding) {
            boolean canSaddle;
            if (itemstack.func_111282_a(player, (EntityLivingBase)this, hand)) {
                return true;
            }
            boolean bl2 = canSaddle = !this.func_70631_g_() && !this.getSaddled() && itemstack.func_77973_b() == Items.field_151141_av;
            if (canSaddle) {
                this.setSaddled(true);
                this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                itemstack.func_190918_g(1);
                return true;
            }
            if (itemstack.func_77973_b() == Items.field_151097_aZ && this.getSaddled()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.setSaddled(false);
                    EntityItem entityitem = this.func_70099_a(new ItemStack(Items.field_151141_av, 1), 1.0f);
                    entityitem.field_70181_x += (double)(this.field_70146_Z.nextFloat() * 0.05f);
                    entityitem.field_70159_w += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                    entityitem.field_70179_y += (double)((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.1f);
                }
                itemstack.func_77972_a(1, (EntityLivingBase)player);
                this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
                return true;
            }
        }
        if (this.func_70631_g_()) {
            return super.func_184645_a(player, hand);
        }
        if (this.getSaddled() && !this.field_70170_p.field_72995_K && ConfigHandler.phoenix_flight.booleanValue()) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() && this.getSaddled();
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)passenger;
            this.field_70761_aq = entityliving.field_70761_aq;
        }
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF() && this.getSaddled()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = entitylivingbase.field_70702_br * 0.5f;
            forward = entitylivingbase.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                if (this.field_70122_E) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.5f);
                } else if (this.field_70171_ac) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 10.0f);
                } else {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 3.0f);
                }
                super.func_191986_a(strafe, up, forward);
                this.field_70181_x = -Math.sin(Math.toRadians(entitylivingbase.field_70125_A)) + Math.sin(Math.toRadians(entitylivingbase.field_70125_A)) / 2.0 + 0.1;
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, up, forward);
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O / 3.0 + (double)0.145f;
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(50) == 0) {
                this.setBirdType(this.field_70170_p.field_73012_v.nextInt(7) + 1);
            } else {
                this.setBirdType(0);
            }
        }
        return livingdata;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.getSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return ExoticbirdsLootTables.ENTITIES_PHOENIX;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }
}

