/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.TileEntity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pavocado.exoticbirds.entity.Birds.EntityBird;
import pavocado.exoticbirds.network.MessagePlayBirdcageSound;
import pavocado.exoticbirds.network.NetworkHandler;

public abstract class BirdcageLogic {
    private int movementDelay = 0;
    private int soundDelay = -1;
    private BirdSpawnData spawnData = null;
    private double mobRotation;
    private double prevMobRotation;
    private Entity cachedEntity;

    public void setEntityData(NBTTagCompound nbtIn) {
        if (this.spawnData == null) {
            this.spawnData = new BirdSpawnData(nbtIn);
        }
    }

    public NBTTagCompound getEntityData() {
        if (this.spawnData != null) {
            return this.spawnData.getNbt();
        }
        return null;
    }

    public void updateBirdcage() {
        if (this.spawnData != null) {
            if (this.getBirdcageWorld().field_72995_K) {
                --this.movementDelay;
                if (this.movementDelay < 0) {
                    this.movementDelay = this.getBirdcageWorld().field_73012_v.nextInt(160) + 80;
                }
                this.prevMobRotation = this.mobRotation;
                if (this.movementDelay % 50 == 0) {
                    double targetPos = (this.getBirdcageWorld().field_73012_v.nextInt(10) - this.getBirdcageWorld().field_73012_v.nextInt(5)) * 20;
                    this.mobRotation = Math.max(this.mobRotation - 50.0, Math.min(this.mobRotation + 50.0, targetPos));
                }
            } else {
                --this.soundDelay;
                if (this.soundDelay < 0) {
                    this.soundDelay = this.getBirdcageWorld().field_73012_v.nextInt(160) + 80;
                } else if (this.soundDelay == 0) {
                    BlockPos pos = this.getBirdcagePosition();
                    Entity birdEntity = this.getBirdcageEntity();
                    if (birdEntity != null) {
                        NetworkHandler.sendToAllAround(new MessagePlayBirdcageSound(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), new NetworkRegistry.TargetPoint(birdEntity.field_71093_bK, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 15.0));
                    }
                }
            }
        }
    }

    public void spawnEntity() {
        this.spawnEntity(false);
    }

    public void spawnEntity(boolean doDamage) {
        if (this.spawnData != null && !this.getBirdcageWorld().field_72995_K) {
            double d2;
            double d1;
            double d0;
            World world;
            BlockPos blockpos = this.getBirdcagePosition();
            NBTTagCompound nbttagcompound = this.spawnData.getNbt();
            Entity entity = AnvilChunkLoader.func_186054_a((NBTTagCompound)nbttagcompound, (World)(world = this.getBirdcageWorld()), (double)(d0 = (double)blockpos.func_177958_n() + 0.5), (double)(d1 = (double)blockpos.func_177956_o() + 0.2), (double)(d2 = (double)blockpos.func_177952_p() + 0.5), (boolean)false);
            if (entity == null) {
                return;
            }
            entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 90.0f, 90.0f);
            if (this.spawnData.getNbt().func_186856_d() > 0 && this.spawnData.getNbt().func_150297_b("id", 8) && entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_180482_a(world.func_175649_E(new BlockPos(entity)), null);
                if (entity instanceof EntityBird && this.spawnData.getNbt().func_74764_b("Type")) {
                    ((EntityBird)entity).setBirdType(this.spawnData.getNbt().func_74762_e("Type"));
                }
                if (doDamage) {
                    ((EntityLiving)entity).func_70606_j(0.0f);
                }
            }
            AnvilChunkLoader.func_186052_a((Entity)entity, (World)world);
        }
    }

    public Entity getBirdcageEntity() {
        if (this.spawnData != null) {
            NBTTagCompound nbttagcompound = this.spawnData.getNbt();
            World world = this.getBirdcageWorld();
            return AnvilChunkLoader.func_186051_a((NBTTagCompound)nbttagcompound, (World)world, (boolean)false);
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("EntityData", 10)) {
            this.setNextSpawnData(new BirdSpawnData(nbt.func_74775_l("EntityData")));
        }
        if (this.getBirdcageWorld() != null) {
            this.cachedEntity = null;
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.spawnData != null) {
            nbt.func_74782_a("EntityData", (NBTBase)this.spawnData.getNbt().func_74737_b());
        }
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getCachedEntity() {
        if (this.cachedEntity == null && this.spawnData != null) {
            this.cachedEntity = this.getBirdcageEntity();
            if (this.spawnData.getNbt().func_186856_d() > 0 && this.spawnData.getNbt().func_150297_b("id", 8) && this.cachedEntity instanceof EntityLiving) {
                ((EntityLiving)this.cachedEntity).func_180482_a(this.getBirdcageWorld().func_175649_E(new BlockPos(this.cachedEntity)), null);
                if (this.cachedEntity instanceof EntityBird && this.spawnData.getNbt().func_74764_b("Type")) {
                    ((EntityBird)this.cachedEntity).setBirdType(this.spawnData.getNbt().func_74762_e("Type"));
                }
            }
        }
        return this.cachedEntity;
    }

    public void setNextSpawnData(BirdSpawnData p_184993_1_) {
        this.spawnData = p_184993_1_;
    }

    public abstract World getBirdcageWorld();

    public abstract BlockPos getBirdcagePosition();

    @SideOnly(value=Side.CLIENT)
    public double getMobRotation() {
        return this.mobRotation;
    }

    @SideOnly(value=Side.CLIENT)
    public double getPrevMobRotation() {
        return this.prevMobRotation;
    }

    public final class BirdSpawnData {
        private final NBTTagCompound nbt;

        public BirdSpawnData(NBTTagCompound nbtIn) {
            this.nbt = nbtIn;
        }

        public NBTTagCompound getNbt() {
            return this.nbt;
        }
    }
}

