/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.entity.TileEntity;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import pavocado.exoticbirds.blocks.BlockIncubator;
import pavocado.exoticbirds.gui.container.ContainerIncubator;
import pavocado.exoticbirds.items.ItemBirdEgg;

public class TileEntityIncubator
extends TileEntityLockableLoot
implements ITickable,
ISidedInventory {
    private static final int[] SLOTS_TOP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
    private static final int[] SLOTS_BOTTOM = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
    private static final int[] SLOTS_SIDES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};
    private NonNullList<ItemStack> incubatorItemStacks = NonNullList.func_191197_a((int)15, (Object)ItemStack.field_190927_a);
    public int eggIncubateTime;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public int func_70302_i_() {
        return this.incubatorItemStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.incubatorItemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.incubatorItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.incubatorItemStacks, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.incubatorItemStacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.incubatorItemStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.getInventoryStackLimit(index)) {
            stack.func_190920_e(this.getInventoryStackLimit(index));
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.field_190577_o : "container.incubator";
    }

    public boolean func_145818_k_() {
        return this.field_190577_o != null && !this.field_190577_o.isEmpty();
    }

    public void setCustomInventoryName(String name) {
        this.field_190577_o = name;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.incubatorItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.incubatorItemStacks);
        this.eggIncubateTime = compound.func_74762_e("IncubateTime");
        if (compound.func_150297_b("CustomName", 8)) {
            this.field_190577_o = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("IncubateTime", (int)((short)this.eggIncubateTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.incubatorItemStacks);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.field_190577_o);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public int getInventoryStackLimit(int index) {
        return index == 0 ? 64 : 1;
    }

    public boolean isBurning() {
        return this.eggIncubateTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstack = (ItemStack)this.incubatorItemStacks.get(0);
            if (!itemstack.func_190926_b()) {
                if (this.canSmelt()) {
                    ++this.eggIncubateTime;
                    if (this.eggIncubateTime == 500 && !itemstack.func_190926_b()) {
                        Item item = itemstack.func_77973_b();
                        itemstack.func_190918_g(1);
                        if (itemstack.func_190926_b()) {
                            ItemStack item1 = item.getContainerItem(itemstack);
                            this.incubatorItemStacks.set(1, (Object)item1);
                        }
                        this.eggIncubateTime = 0;
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.eggIncubateTime = 0;
                }
            } else if (this.isBurning()) {
                this.eggIncubateTime = 0;
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                BlockIncubator.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        int filledSpaces = 0;
        for (int i = 1; i < 15; ++i) {
            NBTTagCompound svalue;
            ItemStack currentEgg = (ItemStack)this.incubatorItemStacks.get(i);
            if (currentEgg.func_190926_b() || !(currentEgg.func_77973_b() instanceof ItemBirdEgg) || currentEgg.func_77978_p() == null || !currentEgg.func_77978_p().func_74764_b("eggValues") || (svalue = (NBTTagCompound)currentEgg.func_77978_p().func_74781_a("eggValues")).func_74762_e("spawnChance") > 95) continue;
            ++filledSpaces;
        }
        return filledSpaces > 0;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            for (int i = 1; i < 15; ++i) {
                NBTTagCompound svalue;
                ItemStack eggStack;
                Item eggItem;
                if (((ItemStack)this.incubatorItemStacks.get(i)).func_190926_b() || !((eggItem = (eggStack = (ItemStack)this.incubatorItemStacks.get(i)).func_77973_b()) instanceof ItemBirdEgg)) continue;
                if (eggStack.func_77978_p() == null || !eggStack.func_77978_p().func_74764_b("eggValues")) {
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74768_a("spawnChance", 10);
                    eggStack.func_77983_a("eggValues", (NBTBase)nbt);
                    eggStack.func_77982_d(nbt);
                } else if (eggStack.func_77978_p().func_74764_b("eggValues") && (svalue = (NBTTagCompound)eggStack.func_77978_p().func_74781_a("eggValues")).func_74762_e("spawnChance") <= 95) {
                    int spawnValue = 10;
                    spawnValue = svalue.func_74762_e("spawnChance") + 5;
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74768_a("spawnChance", spawnValue);
                    eggStack.func_77983_a("eggValues", (NBTBase)nbt);
                }
                this.incubatorItemStacks.set(i, (Object)eggStack);
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index != 0) {
            return ((ItemStack)this.incubatorItemStacks.get(index)).func_190926_b() && stack.func_77973_b() instanceof ItemBirdEgg;
        }
        return TileEntityIncubator.isItemFuel(stack);
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityIncubator.getItemBurnTime(stack) > 0;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151065_br) {
            return 250;
        }
        return 0;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public String func_174875_k() {
        return "exoticbirds:incubator";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerIncubator(playerInventory, (IInventory)this);
    }

    public void func_174888_l() {
        this.incubatorItemStacks.clear();
    }

    public int func_174887_a_(int id) {
        return this.eggIncubateTime;
    }

    public void func_174885_b(int id, int value) {
        this.eggIncubateTime = value;
    }

    public int func_174890_g() {
        return 1;
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.incubatorItemStacks;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        return (T)super.getCapability(capability, facing);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? SLOTS_BOTTOM : (side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        NBTTagCompound tagCompound;
        Item eggItem;
        if (direction == EnumFacing.DOWN && index > 0 && index < 15 && (eggItem = stack.func_77973_b()) instanceof ItemBirdEgg && (tagCompound = stack.func_77978_p()) != null && tagCompound.func_74764_b("eggValues")) {
            NBTTagCompound svalue = (NBTTagCompound)stack.func_77978_p().func_74781_a("eggValues");
            return svalue.func_74762_e("spawnChance") == 100;
        }
        return false;
    }
}

