/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import pavocado.exoticbirds.entity.Birds.EntityBird;
import pavocado.exoticbirds.init.EnumBirdTypes;

public class GuiBirdBook
extends GuiScreen {
    private static final ResourceLocation background = new ResourceLocation("exoticbirds:textures/gui/birdbook/birdbook.png");
    private static final ResourceLocation icons = new ResourceLocation(":textures/gui/icons.png");
    int xSize = 176;
    int ySize = 166;
    private GuiTextField searchField;
    private RotateButton buttonLeft;
    private RotateButton buttonRight;
    private SpinButton buttonSpin;
    private BirdButton buttonBird1;
    private BirdButton buttonBird2;
    private BirdButton buttonBird3;
    private BirdButton buttonBird4;
    private BirdButton buttonBird5;
    private BirdButton buttonBird6;
    private BirdButton buttonBird7;
    private BirdButton buttonBird8;
    private GenderButton buttonGenderM;
    private GenderButton buttonGenderF;
    private SwitchButton buttonSwitch;
    private boolean wasClicking;
    private float currentScroll;
    private boolean isScrolling;
    private int rotateAngle;
    private boolean autoRotate = true;
    private EnumBirdTypes currentBirdType = null;
    private int currentBirdVariant = 0;
    private EntityPlayer currentPlayer;
    private EntityLiving cachedEntity;
    private List birdList = Lists.newArrayList();

    public GuiBirdBook(EntityPlayer player) {
        this.currentPlayer = player;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        boolean flag = Mouse.isButtonDown((int)0);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        int i1 = x + 69;
        int j1 = y + 22;
        int k1 = i1 + 9;
        int l1 = j1 + 136;
        if (!this.wasClicking && flag && mouseX >= i1 && mouseY >= j1 && mouseX < k1 && mouseY < l1) {
            this.isScrolling = true;
        }
        if (!flag || this.birdList.size() < 8) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - j1) - 7.5f) / ((float)(l1 - j1) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.UpdateBirdSearch();
        }
        this.drawGuiContainerForegroundLayer(mouseX, mouseY);
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        if (this.currentBirdType != null) {
            GuiBirdBook.drawCentralText(this.field_146289_q, "\u00a7l" + I18n.func_135052_a((String)("book.exoticbirds." + this.currentBirdType.getName() + ".name"), (Object[])new Object[0]), x + 153, y + 5, 0x404040);
            GuiBirdBook.drawCentralText(this.field_146289_q, "\u00a7o" + I18n.func_135052_a((String)("book.exoticbirds." + this.currentBirdType.getName() + ".family"), (Object[])new Object[0]), x + 153, y + 15, 0x666666);
            this.buttonGenderM.field_146124_l = false;
            this.buttonGenderF.field_146124_l = false;
            this.buttonSwitch.field_146124_l = false;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)("book.exoticbirds." + this.currentBirdType.getName() + ".info"), (Object[])new Object[0]), x * 2 + 181, y * 2 + 53, 250, 0x5B5B5B);
            GlStateManager.func_179121_F();
            String healthStr = String.valueOf(this.currentBirdType.getMaxHealth() / 2.0);
            if (healthStr.endsWith(".0")) {
                healthStr = healthStr.substring(0, healthStr.length() - 2);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.exoticbirds.health.line", (Object[])new Object[]{healthStr}), x * 2 + 200, y * 2 + 158, 100, 0xFFFFFF);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.exoticbirds.tempt.line", (Object[])new Object[]{this.currentBirdType.getTemptedItemString()}), x * 2 + 190, y * 2 + 169, 120, 0xFFFFFF);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.exoticbirds.breed.line", (Object[])new Object[]{this.currentBirdType.getBreedItemString()}), x * 2 + 190, y * 2 + 179, 120, 0xFFFFFF);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.exoticbirds.tame.line", (Object[])new Object[]{this.currentBirdType.getTameItemString()}), x * 2 + 190, y * 2 + 189, 120, 0xFFFFFF);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.exoticbirds.egg.line", (Object[])new Object[0]), x * 2 + 190, y * 2 + 209, 115, 0xFFFFFF);
            String entityNumber = this.currentBirdType.getNumberOfTypes() > 1 && !this.currentBirdType.isGendered() ? String.valueOf(this.currentBirdVariant % this.currentBirdType.getNumberOfTypes()) : "";
            String entityName = I18n.func_135052_a((String)("species.exoticbirds." + this.currentBirdType.getName() + entityNumber + ".name"), (Object[])new Object[0]);
            this.field_146289_q.func_78279_b(entityName, x * 2 + 317, y * 2 + 155, 90, 0xFFFFFF);
            if (this.currentBirdType.isGendered()) {
                String genderTranslation = this.currentBirdVariant % 2 == 0 ? "book.exoticbirds.gender.male" : "book.exoticbirds.gender.female";
                this.field_146289_q.func_78279_b(I18n.func_135052_a((String)genderTranslation, (Object[])new Object[]{""}), x * 2 + 317, y * 2 + 269, 80, 0xFFFFFF);
                this.buttonGenderM.field_146124_l = true;
                this.buttonGenderF.field_146124_l = true;
            } else {
                this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"book.exoticbirds.types.line", (Object[])new Object[]{this.currentBirdVariant + 1, this.currentBirdType.getNumberOfTypes()}), x * 2 + 317, y * 2 + 269, 80, 0xFFFFFF);
                this.buttonSwitch.field_146124_l = true;
            }
            GlStateManager.func_179121_F();
            if (this.currentBirdType.getNumberOfTypes() == 1) {
                this.buttonSwitch.field_146124_l = false;
            }
        } else {
            this.field_146289_q.func_78279_b("\u00a7o" + I18n.func_135052_a((String)"book.exoticbirds.select.line", (Object[])new Object[0]), x + 103, y + 25, 100, 0x404040);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(x, y, 0, 0, this.xSize, this.ySize);
        if (this.currentBirdType != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            this.field_146297_k.func_110434_K().func_110577_a(icons);
            this.func_73729_b(x * 2 + 187, y * 2 + 157, 52, 9, 9, 9);
            this.func_73729_b(x * 2 + 187, y * 2 + 157, 52, 0, 9, 9);
            GlStateManager.func_179121_F();
            this.drawEntityOnScreen(x + 184, y + 130, this.currentBirdType.getModelScale() * 20.0f, (float)(y + 75) - (float)mouseY);
            if (this.cachedEntity instanceof EntityBird) {
                ItemStack eggItem = ((EntityBird)this.cachedEntity).getEgg();
                this.drawEgg(eggItem, x / 2 + 53, y / 2 + 53);
            }
        }
        this.field_146297_k.func_110434_K().func_110577_a(background);
        if (this.birdList.size() > 8) {
            this.func_73729_b(x + 69, (int)((float)(y + 22) + 123.0f * this.currentScroll), 0, 220, 9, 13);
        } else {
            this.func_73729_b(x + 69, (int)((float)(y + 22) + 123.0f * this.currentScroll), 9, 220, 9, 13);
        }
        this.searchField.func_146194_f();
        this.rotateEntity(mouseX, mouseY);
    }

    public void func_73866_w_() {
        this.xSize = 220;
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        int i = (this.field_146294_l - this.xSize) / 2;
        int j = (this.field_146295_m - this.ySize) / 2;
        this.buttonLeft = new RotateButton(1, i + 158, j + 144, true);
        this.field_146292_n.add(this.buttonLeft);
        this.buttonRight = new RotateButton(2, i + 199, j + 144, false);
        this.field_146292_n.add(this.buttonRight);
        this.buttonSpin = new SpinButton(3, i + 171, j + 145);
        this.field_146292_n.add(this.buttonSpin);
        this.buttonBird1 = new BirdButton(4, i + 6, j + 22);
        this.field_146292_n.add(this.buttonBird1);
        this.buttonBird2 = new BirdButton(5, i + 6, j + 39);
        this.field_146292_n.add(this.buttonBird2);
        this.buttonBird3 = new BirdButton(6, i + 6, j + 56);
        this.field_146292_n.add(this.buttonBird3);
        this.buttonBird4 = new BirdButton(7, i + 6, j + 73);
        this.field_146292_n.add(this.buttonBird4);
        this.buttonBird5 = new BirdButton(8, i + 6, j + 90);
        this.field_146292_n.add(this.buttonBird5);
        this.buttonBird6 = new BirdButton(9, i + 6, j + 107);
        this.field_146292_n.add(this.buttonBird6);
        this.buttonBird7 = new BirdButton(10, i + 6, j + 124);
        this.field_146292_n.add(this.buttonBird7);
        this.buttonBird8 = new BirdButton(11, i + 6, j + 141);
        this.field_146292_n.add(this.buttonBird8);
        this.buttonGenderF = new GenderButton(12, i + 111, j + 144, true);
        this.field_146292_n.add(this.buttonGenderF);
        this.buttonGenderM = new GenderButton(13, i + 91, j + 144, false);
        this.field_146292_n.add(this.buttonGenderM);
        this.buttonSwitch = new SwitchButton(14, i + 134, j + 144);
        this.field_146292_n.add(this.buttonSwitch);
        this.searchField = new GuiTextField(0, this.field_146289_q, i + 9, j + 9, 69, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(11);
        this.searchField.func_146185_a(false);
        this.searchField.func_146189_e(true);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146205_d(false);
        this.searchField.func_146195_b(true);
        this.searchField.func_146180_a("");
        this.UpdateBirdSearch();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 1 || button.field_146127_k == 2) {
                this.autoRotate = false;
            } else if (button.field_146127_k == 3) {
                this.autoRotate = !this.autoRotate;
            } else if (button.field_146127_k == 12 || button.field_146127_k == 13) {
                if (this.currentBirdType != null && this.currentBirdType.isGendered()) {
                    this.currentBirdVariant = button.field_146127_k - 12;
                    this.updateCachedEntity();
                }
            } else if (button.field_146127_k == 14) {
                if (this.currentBirdType != null && !this.currentBirdType.isGendered()) {
                    this.currentBirdVariant = (this.currentBirdVariant + 1) % this.currentBirdType.getNumberOfTypes();
                    this.updateCachedEntity();
                }
            } else if (button instanceof BirdButton) {
                this.currentBirdVariant = 0;
                this.currentBirdType = ((BirdButton)button).birdType;
                this.updateCachedEntity();
            }
        }
    }

    private void updateCachedEntity() {
        if (this.currentBirdType != null) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("id", "exoticbirds:" + this.currentBirdType.getName());
            this.cachedEntity = (EntityLiving)AnvilChunkLoader.func_186051_a((NBTTagCompound)compound, (World)this.currentPlayer.field_70170_p, (boolean)false);
            if (this.cachedEntity instanceof EntityBird) {
                ((EntityBird)this.cachedEntity).setBirdType(this.currentBirdVariant);
            }
        } else {
            this.cachedEntity = null;
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchField.func_146201_a(typedChar, keyCode)) {
            this.currentScroll = 0.0f;
            this.UpdateBirdSearch();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void rotateEntity(int mouseX, int mouseY) {
        boolean mouseFlag = Mouse.isButtonDown((int)0);
        if (!this.autoRotate) {
            if (mouseFlag && this.buttonLeft.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                ++this.rotateAngle;
            }
            if (mouseFlag && this.buttonRight.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
                --this.rotateAngle;
            }
        } else {
            this.rotateAngle = (int)(Minecraft.func_71386_F() / 8L % 360L);
        }
        this.rotateAngle %= 360;
    }

    public static void drawCentralText(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        fontRendererIn.func_78276_b(text, x - fontRendererIn.func_78256_a(text) / 2, y, color);
    }

    protected void drawEgg(ItemStack item, int x, int y) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        GlStateManager.func_179145_e();
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        this.field_146296_j.func_180450_b(item, x, y);
        this.field_146296_j.func_175030_a(this.field_146289_q, item, x, y);
        GlStateManager.func_179140_f();
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
        GlStateManager.func_179121_F();
    }

    public void drawEntityOnScreen(int posX, int posY, float scale, float mouseY) {
        if (this.cachedEntity != null) {
            GlStateManager.func_179142_g();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
            GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f2 = this.cachedEntity.field_70761_aq;
            float f3 = this.cachedEntity.field_70177_z;
            float f4 = this.cachedEntity.field_70125_A;
            float f5 = this.cachedEntity.field_70758_at;
            GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            this.cachedEntity.field_70761_aq = this.rotateAngle;
            this.cachedEntity.field_70759_as = this.cachedEntity.field_70177_z = (float)this.rotateAngle;
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
            RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
            rendermanager.func_178631_a(180.0f);
            rendermanager.func_178633_a(false);
            rendermanager.func_188391_a((Entity)this.cachedEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
            rendermanager.func_178633_a(true);
            this.cachedEntity.field_70761_aq = f2;
            this.cachedEntity.field_70177_z = f3;
            this.cachedEntity.field_70125_A = f4;
            this.cachedEntity.field_70758_at = f5;
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        }
    }

    private void UpdateBirdSearch() {
        this.birdList.clear();
        for (EnumBirdTypes birdType : EnumBirdTypes.values()) {
            if (!birdType.showInBook()) continue;
            String[] o = new String[]{I18n.func_135052_a((String)("book.exoticbirds." + birdType.getName() + ".name"), (Object[])new Object[0]), birdType.getName()};
            this.birdList.add(o);
        }
        Collections.sort(this.birdList, new Comparator<String[]>(){

            @Override
            public int compare(String[] first, String[] second) {
                return first[0].compareTo(second[0]);
            }
        });
        ArrayList birdList1 = Lists.newArrayList();
        String s1 = this.searchField.func_146179_b().toLowerCase();
        for (int i = 0; i < this.birdList.size(); ++i) {
            if (!TextFormatting.func_110646_a((String)I18n.func_135052_a((String)("book.exoticbirds." + ((String[])this.birdList.get(i))[1].toString() + ".name"), (Object[])new Object[0])).toLowerCase().contains(s1)) continue;
            birdList1.add(TextFormatting.func_110646_a((String)((String[])this.birdList.get(i))[1].toString()).toLowerCase());
        }
        this.birdList = birdList1;
        this.updateFilteredItems();
    }

    private void updateFilteredItems() {
        for (int i = 3; i < this.field_146292_n.size(); ++i) {
            if (!(this.field_146292_n.get(i) instanceof BirdButton)) continue;
            ((BirdButton)((Object)this.field_146292_n.get((int)i))).field_146126_j = "";
            ((BirdButton)((Object)this.field_146292_n.get((int)i))).birdType = null;
            ((BirdButton)((Object)this.field_146292_n.get((int)i))).field_146125_m = false;
        }
        for (int j = 0; j < MathHelper.func_76125_a((int)this.birdList.size(), (int)0, (int)8); ++j) {
            int q = j + MathHelper.func_76125_a((int)((int)(this.currentScroll * (float)(this.birdList.size() - 8))), (int)0, (int)this.birdList.size());
            ((BirdButton)((Object)this.field_146292_n.get((int)(j + 3)))).field_146126_j = I18n.func_135052_a((String)("book.exoticbirds." + this.birdList.get(q).toString() + ".name"), (Object[])new Object[0]);
            ((BirdButton)((Object)this.field_146292_n.get((int)(j + 3)))).birdType = EnumBirdTypes.byLocalisation(this.birdList.get(q).toString());
            ((BirdButton)((Object)this.field_146292_n.get((int)(j + 3)))).field_146125_m = true;
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.birdList.size() > 8) {
            int j = this.birdList.size() - 8;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.UpdateBirdSearch();
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class SwitchButton
    extends GuiButton {
        public SwitchButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 18, 18, "");
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(background);
                int k = 147;
                int l = 166;
                if (!this.field_146124_l) {
                    l += this.field_146121_g * 2;
                } else if (flag) {
                    l += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class GenderButton
    extends GuiButton {
        public boolean female = true;

        public GenderButton(int buttonId, int x, int y, boolean genderF) {
            super(buttonId, x, y, 18, 18, "");
            this.female = genderF;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(background);
                int k = 0;
                int l = 166;
                if (this.female) {
                    k += this.field_146120_f;
                }
                if (!this.field_146124_l) {
                    l += this.field_146121_g * 2;
                } else if (flag) {
                    l += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class BirdButton
    extends GuiButton {
        public EnumBirdTypes birdType = EnumBirdTypes.CASSOWARY;

        public BirdButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 60, 17, "");
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(background);
                int k = 85;
                int l = 166;
                if (flag) {
                    l += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GuiBirdBook.drawCentralText(mc.field_71466_p, this.field_146126_j, this.field_146128_h * 2 + (this.field_146120_f + 60) / 2, this.field_146129_i * 2 + (this.field_146121_g + 9) / 2, 0xFFFFFF);
                GlStateManager.func_179121_F();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class SpinButton
    extends GuiButton {
        public SpinButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 26, 15, I18n.func_135052_a((String)"book.exoticbirds.button.spin", (Object[])new Object[0]));
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(background);
                int k = 58;
                int l = 166;
                if (flag) {
                    l += this.field_146121_g;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GuiBirdBook.drawCentralText(mc.field_71466_p, "\u00a7l" + this.field_146126_j, this.field_146128_h * 2 + (this.field_146120_f + 26) / 2, this.field_146129_i * 2 + (this.field_146121_g + 8) / 2, 0x404040);
                GlStateManager.func_179121_F();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class RotateButton
    extends GuiButton {
        private final boolean isFlipped;

        public RotateButton(int buttonId, int x, int y, boolean mirror) {
            super(buttonId, x, y, 11, 17, "");
            this.isFlipped = mirror;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(background);
                int k = 36;
                int l = 166;
                if (flag) {
                    l += this.field_146121_g;
                }
                if (this.isFlipped) {
                    k += this.field_146120_f;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, k, l, this.field_146120_f, this.field_146121_g);
            }
        }
    }
}

