/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import pavocado.exoticbirds.init.EnumBirdTypes;

public class ExoticbirdsSpawning {
    static HashMap<BiomeDictionary.Type, ArrayList<Class<? extends EntityLiving>>> spawnMap = new HashMap();

    public static void init() {
        for (EnumBirdTypes birdType : EnumBirdTypes.values()) {
            if (!birdType.canSpawn() || birdType.getBiomes() == null) continue;
            ExoticbirdsSpawning.registerSpawning(birdType.getEntityClass(), birdType.getSpawnRarity(), birdType.getBiomes(), birdType.getMinSpawnGroup(), birdType.getMaxSpawnGroup());
        }
    }

    private static void registerSpawning(Class<? extends EntityLiving> entityClass, int weightedProb, BiomeDictionary.Type[][] biomeTypesGroup, int minSpawnSize, int maxSpawnSize) {
        if (weightedProb > 0) {
            for (Biome biome : Biome.field_185377_q) {
                for (BiomeDictionary.Type[] biomeGroup : biomeTypesGroup) {
                    boolean hasAllTypes = true;
                    for (BiomeDictionary.Type biomeType : biomeGroup) {
                        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)biomeType)) continue;
                        hasAllTypes = false;
                        break;
                    }
                    if (!hasAllTypes) continue;
                    List spawnList = biome.func_76747_a(EnumCreatureType.CREATURE);
                    spawnList.add(new Biome.SpawnListEntry(entityClass, weightedProb, minSpawnSize, maxSpawnSize));
                }
            }
        }
    }
}

