/*
 * Decompiled with CFR 0.152.
 */
package pavocado.exoticbirds.init.handlers;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pavocado.exoticbirds.entity.Birds.EntityBird;
import pavocado.exoticbirds.entity.Birds.EntityPigeon;
import pavocado.exoticbirds.entity.Birds.Phoenix.EntityPhoenix;
import pavocado.exoticbirds.entity.EntityBirdEgg;
import pavocado.exoticbirds.entity.TileEntity.TileEntityBirdcage;
import pavocado.exoticbirds.entity.TileEntity.TileEntityEggSorter;
import pavocado.exoticbirds.entity.TileEntity.TileEntityIncubator;
import pavocado.exoticbirds.entity.TileEntity.TileEntityNest;
import pavocado.exoticbirds.entity.TileEntity.TileEntityPhoenixEgg;
import pavocado.exoticbirds.init.EnumBirdTypes;
import pavocado.exoticbirds.init.ExoticbirdsBlocks;
import pavocado.exoticbirds.init.ExoticbirdsItems;
import pavocado.exoticbirds.init.ExoticbirdsSoundEvents;
import pavocado.exoticbirds.init.RecipesBirdEggs;
import pavocado.exoticbirds.init.handlers.ConfigHandler;
import pavocado.exoticbirds.items.ItemBirdcage;

@Mod.EventBusSubscriber
public class EBEventHandler {
    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("exoticbirds")) {
            ConfigManager.load((String)"exoticbirds", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : ExoticbirdsItems.ITEMS) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        for (Block block : ExoticbirdsBlocks.BLOCKS) {
            event.getRegistry().register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
        }
        event.getRegistry().register(new ItemBirdcage(ExoticbirdsBlocks.birdcage_gold).setRegistryName(ExoticbirdsBlocks.birdcage_gold.getRegistryName()));
        event.getRegistry().register(new ItemBirdcage(ExoticbirdsBlocks.birdcage_iron).setRegistryName(ExoticbirdsBlocks.birdcage_iron.getRegistryName()));
        event.getRegistry().register(new ItemBirdcage(ExoticbirdsBlocks.birdcage_oak).setRegistryName(ExoticbirdsBlocks.birdcage_oak.getRegistryName()));
        event.getRegistry().register(new ItemBirdcage(ExoticbirdsBlocks.birdcage_spruce).setRegistryName(ExoticbirdsBlocks.birdcage_spruce.getRegistryName()));
        event.getRegistry().register(new ItemBirdcage(ExoticbirdsBlocks.birdcage_birch).setRegistryName(ExoticbirdsBlocks.birdcage_birch.getRegistryName()));
        event.getRegistry().register(new ItemBirdcage(ExoticbirdsBlocks.birdcage_jungle).setRegistryName(ExoticbirdsBlocks.birdcage_jungle.getRegistryName()));
        event.getRegistry().register(new ItemBirdcage(ExoticbirdsBlocks.birdcage_acacia).setRegistryName(ExoticbirdsBlocks.birdcage_acacia.getRegistryName()));
        event.getRegistry().register(new ItemBirdcage(ExoticbirdsBlocks.birdcage_dark_oak).setRegistryName(ExoticbirdsBlocks.birdcage_dark_oak.getRegistryName()));
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : ExoticbirdsBlocks.BLOCKS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : ExoticbirdsBlocks.BLOCKS_NO_ITEMS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        for (Block block : ExoticbirdsBlocks.BLOCKS_CUSTOM_ITEMS) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
        GameRegistry.registerTileEntity(TileEntityNest.class, (ResourceLocation)new ResourceLocation("exoticbirds", "nest"));
        GameRegistry.registerTileEntity(TileEntityEggSorter.class, (ResourceLocation)new ResourceLocation("exoticbirds", "egg_sorter"));
        GameRegistry.registerTileEntity(TileEntityIncubator.class, (ResourceLocation)new ResourceLocation("exoticbirds", "egg_incubator"));
        GameRegistry.registerTileEntity(TileEntityPhoenixEgg.class, (ResourceLocation)new ResourceLocation("exoticbirds", "phoenix_egg"));
        GameRegistry.registerTileEntity(TileEntityBirdcage.class, (ResourceLocation)new ResourceLocation("exoticbirds", "birdcage"));
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        Item item;
        for (Item item2 : ExoticbirdsItems.ITEMS) {
            ModelLoader.setCustomModelResourceLocation((Item)item2, (int)0, (ModelResourceLocation)new ModelResourceLocation(item2.getRegistryName(), "inventory"));
        }
        for (Block block : ExoticbirdsBlocks.BLOCKS) {
            item = Item.func_150898_a((Block)block);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
        for (Block block : ExoticbirdsBlocks.BLOCKS_CUSTOM_ITEMS) {
            item = Item.func_150898_a((Block)block);
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        int entityID = 0;
        for (EnumBirdTypes birdType : EnumBirdTypes.values()) {
            EntityEntry entityEntry = EntityEntryBuilder.create().entity(birdType.getEntityClass()).tracker(64, 1, true).id(new ResourceLocation("exoticbirds", birdType.getName()), entityID++).name("exoticbirds." + birdType.getName()).egg(birdType.getPrimaryColor(), birdType.getSecondaryColor()).build();
            event.getRegistry().register((IForgeRegistryEntry)entityEntry);
        }
        EntityEntry entityEntry = EntityEntryBuilder.create().entity(EntityBirdEgg.class).tracker(64, 1, true).id(new ResourceLocation("exoticbirds", "bird_egg"), entityID++).name("exoticbirds.bird_egg").build();
        event.getRegistry().register((IForgeRegistryEntry)entityEntry);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        RecipesBirdEggs recipe = new RecipesBirdEggs();
        recipe.setRegistryName(new ResourceLocation("exoticbirds", "incubate_eggs"));
        event.getRegistry().register((IForgeRegistryEntry)recipe);
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (SoundEvent sound : ExoticbirdsSoundEvents.SOUNDS) {
            event.getRegistry().register((IForgeRegistryEntry)sound);
        }
    }

    @SubscribeEvent
    public static void populateChunk(PopulateChunkEvent event) {
        if (ConfigHandler.spawn_pigeon.booleanValue() && event.isHasVillageGenerated() && new Random().nextInt(3) == 0) {
            World world = event.getWorld();
            BlockPos pos = world.func_175672_r(new BlockPos(event.getChunkX() << 4, 60, event.getChunkZ() << 4));
            EntityPigeon entityPigeon = new EntityPigeon(world);
            entityPigeon.func_180482_a(world.func_175649_E(pos), null);
            entityPigeon.func_70012_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0f, 0.0f);
            world.func_72838_d((Entity)entityPigeon);
        }
    }

    @SubscribeEvent
    public static void entityLoad(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPhoenix) {
            ((EntityPhoenix)event.getEntity()).replaceWithNewPhoenix();
        }
    }

    @SubscribeEvent
    public static void checkSpawns(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntity() instanceof EntityBird) {
            for (int dimensionID : ConfigHandler.blacklisted_spawning_dimensions) {
                if (event.getEntity().field_71093_bK != dimensionID) continue;
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void addLoot(LootTableLoadEvent event) {
        if (ConfigHandler.gen_dungeons.booleanValue()) {
            String name = event.getName().toString();
            if (name.equals("minecraft:chests/abandoned_mineshaft") || name.equals("minecraft:chests/desert_pyramid") || name.equals("minecraft:chests/simple_dungeon")) {
                LootEntryTable entry = new LootEntryTable(new ResourceLocation("exoticbirds", "dungeon_phoenix"), 1, 0, new LootCondition[0], "exoticbirds_inject_entry");
                LootPool phoenixPool = new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "exoticbirds_inject_pool");
                event.getTable().addPool(phoenixPool);
            } else if (name.equals("birdsnests:nest_loot")) {
                LootEntryTable entry = new LootEntryTable(new ResourceLocation("exoticbirds", "birdsnests_loot"), 1, 0, new LootCondition[0], "exoticbirds_inject_entry");
                LootPool nestPool = new LootPool(new LootEntry[]{entry}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "exoticbirds_inject_pool");
                event.getTable().addPool(nestPool);
            }
        }
    }
}

